% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_changepoint.R
\name{elastic_ph_change_ff}
\alias{elastic_ph_change_ff}
\title{Elastic Phase Changepoint Detection}
\usage{
elastic_ph_change_ff(
  f,
  time,
  d = 1000,
  h = 0,
  smooth_data = FALSE,
  sparam = 25,
  showplot = TRUE
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{d}{number of monte carlo iterations of Brownian Bridge (default = 1000)}

\item{h}{window selection of long range covariance function (default = 0)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{showplot}{show results plots (default = T)}
}
\value{
Returns a list object containing
\item{pvalue}{p value}
\item{change}{indice of changepoint}
\item{DataBefore}{functions before changepoint}
\item{DataAfter}{functions after changepoint}
\item{MeanBefore}{mean function before changepoint}
\item{MeanAfter}{mean function after changepoint}
\item{WarpingBefore}{warping functions before changepoint}
\item{WarpingAfter}{warping functions after changepoint}
\item{WarpingMeanBefore}{mean warping function before changepoint}
\item{WarpingMeanAfter}{mean warping function after changepoint}
\item{change_fun}{amplitude change function}
\item{Sn}{test statistic values}
\item{mu}{mean shooting vectors}
}
\description{
This function identifies a phase changepoint using a fully functional
approach
}
\references{
J. D. Tucker and D. Yarger, “Elastic Functional Changepoint
Detection of Climate Impacts from Localized Sources”, Envirometrics,
10.1002/env.2826, 2023.
}
\keyword{alignment}
\keyword{changepoint}
\keyword{srvf}
