% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_geodesic.R
\name{curve_geodesic}
\alias{curve_geodesic}
\title{Form geodesic between two curves}
\usage{
curve_geodesic(beta1, beta2, k = 5)
}
\arguments{
\item{beta1}{curve 1, provided as a matrix of dimensions \eqn{n \times T} for
\eqn{n}-dimensional curve evaluated on \eqn{T} sample points}

\item{beta2}{curve 2, provided as a matrix of dimensions \eqn{n \times T} for
\eqn{n}-dimensional curve evaluated on \eqn{T} sample points}

\item{k}{number of curves along geodesic (default \code{5})}
}
\value{
a list containing \item{geod}{curves along geodesic (n,T,k)}
\item{geod_q}{srvf's along geodesic}
}
\description{
Form geodesic between two curves using Elastic Method
}
\examples{
out <- curve_geodesic(beta[, , 1, 1], beta[, , 1, 5])
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
