% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{glance.RW}
\alias{glance.RW}
\title{Glance a lag walk model}
\usage{
\method{glance}{RW}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the lag walk model.
Contains the variance of residuals (\code{sigma2}).
}
\examples{
as_tsibble(Nile) \%>\%
  model(NAIVE(value)) \%>\%
  glance()

library(tsibbledata)
aus_production \%>\%
  model(snaive = SNAIVE(Beer ~ lag("year"))) \%>\%
  glance()
}
