% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot expression data along a trajectory}
\usage{
plot_heatmap(
  trajectory,
  expression_source = "expression",
  features_oi = 20,
  clust = "ward.D2",
  margin = 0.02,
  color_cells = NULL,
  milestones = NULL,
  milestone_percentages = trajectory$milestone_percentages,
  grouping = NULL,
  groups = NULL,
  cell_feature_importances = NULL,
  heatmap_type = c("tiled", "dotted"),
  scale = dynutils::scale_quantile,
  label_milestones = TRUE
)
}
\arguments{
\item{trajectory}{A dynwrap trajectory.}

\item{expression_source}{Source of the feature expression, defaults to \code{get_expression(trajectory)}.}

\item{features_oi}{The features of interest, either the number of features or a vector giving the names of the different features}

\item{clust}{The method to cluster the features, or a hclust object}

\item{margin}{A margin between trajectory segments.}

\item{color_cells}{How to color the cells.
\itemize{
\item \code{"auto"}: Try to figure out how to color cells depending on whether
one of the \code{grouping}, \code{feature_io}, \code{milestones} or \code{pseudotime} parameters are defined.
\item \code{"none"}: Cells are not coloured.
\item \code{"grouping"}: Cells are coloured according to a grouping (e.g. clustering).
Either the \code{grouping} parameter or \code{trajectory$grouping} must be a named character vector.
\item \code{"feature"}: Cells are coloured according to the values of a given feature (e.g. gene expression).
Either the \code{expression_source} parameter or \code{get_expression(trajectory)} must be a matrix.
Parameter \code{feature_oi} must also be defined.
\item \code{"milestone"} (recommended): Cells are coloured according their position in the trajectory. The positioning of the
cells are determined by parameter \code{milestone_percentages} or else by \code{trajectory$milestone_percentages}. The colours
of the milestones can be determined automatically or can be specified by passing a tibble containing character columns
\code{milestone_id} and \code{color} (See \code{add_milestone_coloring()} for help in constructing this object).
\item \code{"pseudotime"}: Cells are coloured according to the pseudotime value from the root.
}}

\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{milestone_percentages}{The milestone percentages.}

\item{grouping}{A grouping of the cells (e.g. clustering) as a named character vector.}

\item{groups}{A tibble containing character columns \code{group_id} and \code{color}. If \code{NULL}, this object is inferred from the \code{grouping} itself.}

\item{cell_feature_importances}{The importances of every feature in every cell, as returned by \code{\link[dynfeature:calculate_overall_feature_importance]{dynfeature::calculate_cell_feature_importance()}}}

\item{heatmap_type}{The type of heatmap, either tiled or dotted}

\item{scale}{Whether to rescale the expression, can be a function or boolean}

\item{label_milestones}{How to label the milestones. Can be TRUE (in which case the labels within the trajectory will be used), "all" (in which case both given labels and milestone_ids will be used), a named character vector, or FALSE}
}
\value{
A heatmap ggplot of an expression dataset with trajectory.
}
\description{
\verb{NOTE:} When using RStudio, the heatmap might not show inside the plot area, but will be visible once you click the 'Zoom' button.
}
\examples{
data(example_bifurcating)
plot_heatmap(example_bifurcating)

}
\keyword{plot_trajectory}
