% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_insights.R
\name{get_insights}
\alias{get_insights}
\title{Get insights for a project.}
\usage{
get_insights(project_owner, project_id, limit = NULL,
  next_page_token = NULL)
}
\arguments{
\item{project_owner}{username of the owner of the project.}

\item{project_id}{identifier of the project.}

\item{limit}{Maximum number of items to return}

\item{next_page_token}{Unique token used to retrieve next page}
}
\value{
a named list with at most two elements.  It will
always contain a list, named \code{records},
of objects of type \code{insight_summary_response}.
If the call to \code{get_insights()}
was made with a non-null
\code{limit} parameter, and if further pages remain for
retrieval, then
the list will also contain a single-element character vector,
named \code{next_page_token},
with the token to use in a subsequent call to get the next page.
}
\description{
Get insights for a project.
}
\examples{
\dontrun{
  dwapi::get_insights(project_owner = "user", project_id = "project_id")
}
}
