% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{push_frame}
\alias{push_frame}
\title{Creates a Frame, Commits and Pushes Data in a Single Operation}
\usage{
push_frame(
  stack,
  obj,
  description = NULL,
  params = NULL,
  message = NULL,
  profile = "default",
  handler = auto_handler(),
  protocol = NULL,
  encryption = .no_encryption,
  ...
)
}
\arguments{
\item{stack}{A name of stack to use.}

\item{obj}{Object to commit and push, e.g. plot.}

\item{description}{Optional description of the object.}

\item{params}{Optional parameters.}

\item{message}{Push message. \code{NULL} by default.}

\item{profile}{Profile you want to use, i.e. username and token. Default profile is 'default'.}

\item{handler}{Specify handler to handle the object, if it's None then \code{auto_handler} will be used.}

\item{protocol}{Protocol to use, usually it is \code{NULL} it means that \code{json_protocol} will be used.}

\item{encryption}{Encryption method by default \code{no_encryption} will be used.}

\item{...}{Optional parameters is an alternative to \code{params}. If both are present this one will be merged into params.}
}
\value{
Stack URL.
}
\description{
In the case of one plot per push you can use do all operations in one call.
This function creates a frame, commits view and pushes all data to server.
The main difference in behaviour in this case is the function creates frame
without permission check, so be sure that you have certain permission to push in the stack.
}
\examples{
\donttest{
library(ggplot2)
library(dstack)
image <- qplot(clarity, data = diamonds, fill = cut, geom = "bar")
push_frame("diamonds", image, "Diamonds bar chart")
}
}
