% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.disbayes}
\alias{tidy.disbayes}
\alias{tidy.disbayes_hier}
\title{Form a tidy data frame from the estimates from a disbayes fit}
\usage{
\method{tidy}{disbayes}(x, startyear = 1, ...)

\method{tidy}{disbayes_hier}(x, ...)
}
\arguments{
\item{x}{Object returned by \code{\link{disbayes}}}

\item{startyear}{Only used for models with time trends.  Numeric year represented by year 1 in the data. For example, set this to 1918 to convert years 1-100 to years 1918-2017.}

\item{...}{Other arguments (currently unused)}
}
\value{
A data frame with one row per model parameter, giving summary statistics
for the posterior distribution for that parameter.   For array parameters, e.g. those
that depend on age or area, then the age and area are returned in separate columns,
to make it easier to summarise and plot the results, e.g. using \pkg{ggplot2}.

Model parameters might include, depending on the model specification,
\itemize{
\item \code{cf}, \code{inc}, \code{rem}: Case fatality, incidence, remission rates
\item \code{inc_prob}, \code{rem_prob}, \code{mort_prob}, \code{cf_prob}:  Annual incidence, remission, mortality and case fatality risks (probabilities).
\item \code{prev_prob} Prevalence (probability).
\item \code{state_probs} State occupancy probabilities.
\item \code{beta}, \code{beta_inc} Coefficients of the spline basis for case fatality and incidence respectively.
\item \code{lambda_cf}, \code{lambda_inc} Smoothness parameters of the spline functions.
\item \code{prevzero} Prevalence at age zero
\item \code{cfbase} Case fatality at the baseline age (only in models where case fatality is increasing).
\item \code{dcf} Annual increments in case fatality (only in models where case fatality is increasing).
\item \code{bias_loghr} Log hazard ratio describing bias in case fatality between datasets (only in models where \code{bias_model} has been set).
}

For models with time trends:
\itemize{
\item \code{cf_yr}, \code{inc_yr}, \code{state_probs_yr} Case fatality rates, incidence rates and state occupancy probabilities in years prior to the current year.  \code{cf} and \code{inc} refer to the rates for the current year, the one represented in the data.
}

Only for hierarchical models:
\itemize{
\item \code{mean_inter}, \code{mean_slope},\code{sd_inter},\code{sd_slope}.  Mean and standard deviation for random effects distribution for the intercept and slope of log case fatality.
\item \code{lambda_cf_male}, \code{lambda_inc_male}.  Smoothness of the additive gender effect on case fatality and incidence.
\item \code{bareat} Area-level contribution to spline basis coefficients.
\item \code{barea}  Normalised spline basis coefficients.
}
}
\description{
Simply call this after fitting disbayes, as, e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{res <- disbayes(...)
tidy(res)
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{tidy.disbayes_hier}: Tidy method for hierarchical disbayes models
}}

