/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.qa;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.qa.diff.BufferGeometryMatcher;
import com.vividsolutions.jump.qa.diff.DiffGeometryComponents;
import com.vividsolutions.jump.qa.diff.DiffSegments;
import com.vividsolutions.jump.qa.diff.DiffSegmentsWithTolerance;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.ColorUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DiffGeometryPlugIn
extends ThreadedBasePlugIn {
    private static final String LAYER1 = "Layer 1";
    private static final String LAYER2 = "Layer 2";
    private static final String MATCH_SEGMENTS = "Match Segments";
    private static final String MATCH_GEOMETRY = "Match entire Geometry";
    private static final String EXACT_COORD_ORDER = "Test for identical Start point and Orientation";
    private static final String USE_TOLERANCE = "Match using Distance Tolerance";
    private static final String DISTANCE_TOL = "Distance Tolerance";
    private static final String SPLIT_COMPONENTS = "Match components of MultiGeometries";
    private MultiInputDialog dialog;
    private Layer layer1;
    private Layer layer2;
    private boolean matchGeometry = false;
    private boolean useTolerance = false;
    private double distanceTolerance = 1.0;
    private boolean testExactCoordinateOrder = false;
    private boolean splitIntoComponents = false;
    private JRadioButton matchSegmentsRB;
    private JRadioButton matchGeometryRB;
    private JCheckBox matchGeometryCheckbox;
    private JCheckBox splitComponentsCheckbox;
    private JCheckBox exactOrderCheckbox;
    private JCheckBox useToleranceCheckbox;
    private JTextField distanceTextField;

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection[] diffFC = new FeatureCollection[]{this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper()};
        if (this.matchGeometry) {
            DiffGeometryComponents diff = new DiffGeometryComponents(this.layer1.getFeatureCollectionWrapper(), this.layer2.getFeatureCollectionWrapper(), monitor);
            diff.setNormalize(!this.testExactCoordinateOrder);
            diff.setSplitIntoComponents(this.splitIntoComponents);
            if (this.useTolerance) {
                diff.setMatcher(new BufferGeometryMatcher(this.distanceTolerance));
            }
            diffFC = diff.diff();
        }
        monitor.report("Computing Segment Diffs");
        FeatureCollection[] diffSegFC = this.diffSegments(diffFC, monitor);
        this.createLayers(context, diffFC, diffSegFC);
        this.createOutput(context, diffFC, diffSegFC);
    }

    public FeatureCollection[] diffSegments(FeatureCollection[] diffFC, TaskMonitor monitor) throws Exception {
        FeatureCollection[] diffSegFC;
        if (!this.useTolerance) {
            DiffSegments diff = new DiffSegments(monitor);
            diff.setSegments(0, diffFC[0]);
            diff.setSegments(1, diffFC[1]);
            diffSegFC = new FeatureCollection[]{diff.computeDiffEdges(0), diff.computeDiffEdges(1)};
        } else {
            DiffSegmentsWithTolerance diff = new DiffSegmentsWithTolerance(diffFC[0], diffFC[1], this.distanceTolerance);
            diffSegFC = diff.diff();
        }
        return diffSegFC;
    }

    public static void setDiffGeometryStyle(Layer lyr, Color fillColor, Color lineColor) {
        lyr.getBasicStyle().setRenderingFill(true);
        lyr.getBasicStyle().setFillColor(fillColor);
        lyr.setSynchronizingLineColor(false);
        lyr.getBasicStyle().setAlpha(200);
        lyr.getBasicStyle().setLineWidth(1);
        lyr.getBasicStyle().setLineColor(lineColor);
        lyr.getVertexStyle().setEnabled(false);
    }

    private void createLayers(PlugInContext context, FeatureCollection[] diffFC, FeatureCollection[] diffSegFC) {
        Layer segLyr = context.addLayer("QA", "Segment Diffs - " + this.layer1.getName(), diffSegFC[0]);
        LayerStyleUtil.setLinearStyle((Layer)segLyr, (Color)Color.red, (int)2, (int)4);
        segLyr.fireAppearanceChanged();
        Layer segLyr2 = context.addLayer("QA", "Segment Diffs - " + this.layer2.getName(), diffSegFC[1]);
        LayerStyleUtil.setLinearStyle((Layer)segLyr2, (Color)Color.blue, (int)2, (int)4);
        segLyr2.fireAppearanceChanged();
        if (this.matchGeometry) {
            Layer lyr = context.addLayer("QA", "Geometry Diffs - " + this.layer1.getName(), diffFC[0]);
            DiffGeometryPlugIn.setDiffGeometryStyle(lyr, ColorUtil.PALE_RED, Color.red);
            lyr.fireAppearanceChanged();
            Layer lyr2 = context.addLayer("QA", "Geometry Diffs - " + this.layer2.getName(), diffFC[1]);
            DiffGeometryPlugIn.setDiffGeometryStyle(lyr2, ColorUtil.PALE_BLUE, Color.blue);
            lyr2.fireAppearanceChanged();
        }
    }

    private void createOutput(PlugInContext context, FeatureCollection[] diffFC, FeatureCollection[] diffSegFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, this.getName());
        context.getOutputFrame().addField("Layer 1: ", this.layer1.getName());
        context.getOutputFrame().addField("Layer 2: ", this.layer2.getName());
        if (this.useTolerance) {
            context.getOutputFrame().addField("Distance Tolerance:", "" + this.distanceTolerance);
        }
        if (this.testExactCoordinateOrder) {
            context.getOutputFrame().addField("Test for identical Start point and Orientation:", new Boolean(this.testExactCoordinateOrder).toString());
        }
        if (this.matchGeometry) {
            context.getOutputFrame().addText(" ");
            context.getOutputFrame().addField("# Unmatched Geometries in Layer 1: ", "" + diffFC[0].size());
            context.getOutputFrame().addField("# Unmatched Geometries in Layer 2: ", "" + diffFC[1].size());
        }
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField("# Unmatched Segments in Geometry Diffs in Layer 1: ", "" + diffSegFC[0].size());
        context.getOutputFrame().addField("# Unmatched Segments in Geometry Diffs in Layer 2: ", "" + diffSegFC[1].size());
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("DiffSegments.png")));
        dialog.setSideBarDescription("Finds differences between the Segments or Geometries in two layers.  Matching can be either exact or within a Distance Tolerance.");
        dialog.addLayerComboBox(LAYER1, context.getLayerManager().getLayer(0), context.getLayerManager());
        dialog.addLayerComboBox(LAYER2, context.getLayerManager().getLayer(1), context.getLayerManager());
        String MATCH_TYPE_GROUP = "Match Type";
        this.matchSegmentsRB = dialog.addRadioButton(MATCH_SEGMENTS, "Match Type", !this.matchGeometry, "Matches using segments only");
        this.matchGeometryRB = dialog.addRadioButton(MATCH_GEOMETRY, "Match Type", this.matchGeometry, "Matches using full geometry topology, not just segments");
        this.matchSegmentsRB.addItemListener(new StateItemListener());
        this.matchGeometryRB.addItemListener(new StateItemListener());
        this.splitComponentsCheckbox = dialog.addCheckBox(SPLIT_COMPONENTS, this.splitIntoComponents, "Matches individual components of MultiGeometries");
        this.exactOrderCheckbox = dialog.addCheckBox(EXACT_COORD_ORDER, false, "Requires coordinate lists in matching geometries to have identical start points and ring orientation");
        dialog.addLabel("");
        this.useToleranceCheckbox = dialog.addCheckBox(USE_TOLERANCE, this.useTolerance, "Matches geometries if all points are within the Distance Tolerance of the other Geometry");
        this.distanceTextField = dialog.addDoubleField(DISTANCE_TOL, this.distanceTolerance, 8, "Specifies how close geometries must be to match");
        this.useToleranceCheckbox.addItemListener(new StateItemListener());
        this.updateUI();
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer1 = dialog.getLayer(LAYER1);
        this.layer2 = dialog.getLayer(LAYER2);
        this.matchGeometry = dialog.getBoolean(MATCH_GEOMETRY);
        this.useTolerance = dialog.getBoolean(USE_TOLERANCE);
        this.distanceTolerance = dialog.getDouble(DISTANCE_TOL);
        this.splitIntoComponents = dialog.getBoolean(SPLIT_COMPONENTS);
        this.testExactCoordinateOrder = dialog.getBoolean(EXACT_COORD_ORDER);
    }

    private void updateUI() {
        boolean matchGeometry = this.dialog.getBoolean(MATCH_GEOMETRY);
        this.splitComponentsCheckbox.setEnabled(matchGeometry);
        this.exactOrderCheckbox.setEnabled(matchGeometry);
        boolean useDistance = this.dialog.getBoolean(USE_TOLERANCE);
        this.distanceTextField.setEnabled(useDistance);
        this.distanceTextField.setOpaque(useDistance);
    }

    private class StateItemListener
    implements ItemListener {
        private StateItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            DiffGeometryPlugIn.this.updateUI();
        }
    }
}

