% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Srivastava2011.R
\name{Srivastava2011}
\alias{Srivastava2011}
\title{Test of Structure of a Covariance Matrix given by Srivastava et al. 2011.}
\usage{
Srivastava2011(x, Sigma = "identity", ...)
}
\arguments{
\item{x}{data}

\item{Sigma}{Population covariance matrix}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Structure of a Covariance Matrix given by Srivastava et al. 2011.
}
\details{
The \code{\link{structureCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
Srivastava2011(as.matrix(iris[1:50, 1:4]))

}
\references{
Srivastava, M. S., Kollo, T., and Rosen, D. von. (2011). 
Some Tests for the Covariance Matrix with Fewer Observations then 
the Dimension Under Non-normality. Journal of Multivariate Analysis, 
102(6), 1090-1103. \href{http://doi.org/10.1016/j.jmva.2011.03.003}{10.1016/j.jmva.2011.03.003}
}
