% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTables.R
\name{exportDiffData}
\alias{exportDiffData}
\title{Export the 'diff.data' object from \code{\link{compareDiff}}
to a user-friendly format}
\usage{
exportDiffData(
  diffData,
  newDataDiff,
  oldDataDiff,
  referenceVars = attr(diffData, "referenceVars"),
  changeableVars = attr(diffData, "changeableVars"),
  to = "DT",
  ...
)
}
\arguments{
\item{diffData}{Object of class 'diff.data' containing
differences between datasets, as returned by the \code{\link{compareDiff}} function.}

\item{newDataDiff}{data.frame with new data with differences
as returned by the \code{\link{mergeDiffWithData}}.
The data set contains the new data with the
information if each record differs in the new dataset.}

\item{oldDataDiff}{data.frame with old data with differences
as returned by the \code{\link{mergeDiffWithData}}.
The data set contains the old data with the
information if each record differs in the old dataset.}

\item{referenceVars}{character vector of the columns in the data that are the used as
reference for the comparison. \cr 
If not specified, all columns present both in
\code{newData} and \code{oldData} are considered.}

\item{changeableVars}{character vector of the columns in the data for which you want to assess the change,
e.g. variables that might have changed from the old to the new data.\cr
If not specified, only 'Addition' and 'Removal' are detected.}

\item{to}{String with export format,
currently only: \code{DT} is available to export to
a \code{\link[DT]{datatable}} object.}

\item{...}{Extra parameters besides 'data' and 'nonVisibleVars',
currently passed to the \code{\link{getClinDT}} function.}
}
\value{
Depending on the \code{to} parameter:
\itemize{
\item{'DT': }{a \code{\link[DT]{datatable}} with the difference between datasets,
with:
\itemize{
\item{highlighting depending on the difference between datasets:
\itemize{
\item{'Addition' in green}
\item{'Removal' in yellow}
\item{'Change' in lightblue}
\item{'Identical' are not highlighted}
}
}
\item{records only present in the old dataset are displayed in italic}
}
}
}
}
\description{
Export the 'diff.data' object from \code{\link{compareDiff}}
to a user-friendly format
}
