% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitPrintListPlots.R
\name{knitPrintListPlots}
\alias{knitPrintListPlots}
\title{Include a list of plots in a knitr document}
\usage{
knitPrintListPlots(
  plotsList,
  generalLabel = "plotsList",
  type = c("ggplot2", "plotly"),
  ...
)
}
\arguments{
\item{plotsList}{list of plots, e.g. \code{ggplot} objects
from the \code{ggplot2} package or from the \code{plotly} packages.}

\item{generalLabel}{general label for the chunks, used to build the \code{labels}.
The labels are constructed as '\code{generalLabel}[i]',
with i the plot number (from sequence spanning the length of \code{plotsList}).
Only use if \code{labels} is not specified.}

\item{type}{string with plot type: 'ggplot2' or 'plotly'}

\item{...}{Additional parameters for the \code{\link{knitPrintListObjects}} function.}
}
\value{
No returned value, a text is printed with chunk content
}
\description{
This function includes a list of plots with different figure height, 
size, label in a knitr document.
The reason is that the chunck options 
\code{fig.height} and \code{fig.width} are not vectorized.
}
\details{
Note: the chunk in which this function is called should be 
set with the following option: \strong{\code{results = 'asis'}}.\cr
Note that a (one-level) list of \code{plotly} plots can also be included directly via
\code{htmltools::tagList(listPlots)}, but without the possibility to specify
title and/or change chunk option(s).
Each plot will be included in a separated chunk.\cr
}
\examples{
\dontrun{

# Note: the following code should be included within a chunk of a knitr (e.g. RMarkdown) document
# to include/export a list of figures in the Rmarkdown output
data(iris)

# include a list of static plots
library(ggplot2)
plotsListStatic <- list(
	point = ggplot(data = cars, aes(x = speed, y = dist)) + geom_point(),
	line = ggplot(data = cars, aes(x = speed, y = dist)) + geom_line()
)
# with general label (used to name exported figure)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  generalLabel = "scatter-cars"
)
# with label for each plot (used to name exported figure)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  labels = names(plotsListStatic)
)
# with section header (header of level 1 in Markdown)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  titles = names(plotsListStatic), 
  titleLevel = 3
)
# specify caption and dimension for each figure (figure height is replicated)
knitPrintListPlots(
  plotsList = plotsListStatic, 
  fig.cap = names(plotsListStatic), 
  fig.width = 3*seq_along(plotsListStatic), 
  fig.height = 6
)

# include a list of interactive plots
library(plotly)
plotsListInteractive <- list(
	point = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "marker"),
	line = plot_ly(data = cars, x = ~speed, y = ~dist, type = "scatter", mode = "line")
)
knitPrintListPlots(
 plotsList = plotsListInteractive, 
  type = "plotly", 
  titles = names(plotsListInteractive), 
  titleLevel = 3
)

}
}
\author{
Laure Cougnaud
}
