% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{causalproblemcheck}
\alias{causalproblemcheck}
\title{Check conditions on causal problem}
\usage{
causalproblemcheck(digraph, query)
}
\arguments{
\item{digraph}{An \code{igraph} object representing a digraph.

Expected vertex attributes: \code{leftside}, \code{latent} and \code{nvals}.

Optional vertex attributes: \code{exposure} and \code{outcome}.

Expected edge attributes: \code{rlconnect} and \code{edge.monotone}.}

\item{query}{A string representing a causal query / effect.}
}
\value{
\code{TRUE} if conditions are met; \code{FALSE} otherwise.
}
\description{
Check that a given causal problem (a causal DAG together with a causal query)
satisfies conditions that guarantee that the optimization problem is linear.
}
\examples{
b <- graph_from_literal(X - +Y, Ur - +X, Ur - +Y)
V(b)$leftside <- c(0, 0, 0)
V(b)$latent <- c(0, 0, 1)
V(b)$nvals <- c(2, 2, 2)
V(b)$exposure <- c(1, 0, 0)
V(b)$outcome <- c(0, 1, 0)
E(b)$rlconnect <- c(0, 0, 0)
E(b)$edge.monotone <- c(0, 0, 0)
effectt <- "p{Y(X=1)=1}-p{Y(X=0)=1}"
causalproblemcheck(digraph = b, query = effectt)

}
