% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_exports.R
\name{get_rank_of_players}
\alias{get_rank_of_players}
\title{Generate a ranking of the ability based on sampling the posterior distribution of the ranks.}
\usage{
get_rank_of_players(bpc_object, n = 1000)
}
\arguments{
\item{bpc_object}{a bpc object}

\item{n}{Number of times we will sample the posterior}
}
\value{
a data frame. This data frame contains the median of the rank, the mean, the standard deviation and column with a list containing all the posterior values for the rank
}
\description{
To print this object you should remove the last column PosteriorRank since it contain the whole posterior distribution for each case
}
\examples{
\donttest{
m<-bpc(data = tennis_agresti,
player0 = 'player0',
player1 = 'player1',
result_column = 'y',
model_type = 'bt',
solve_ties = 'none')
rank_m<-get_rank_of_players(m,n=100)
rank_table <- dplyr::select(rank_m,-MeanRank, -StdRank,-PosteriorRank)
print(rank_table)
}
}
