% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqPal.R
\name{seqPal}
\alias{seqPal}
\title{Sequential color palette}
\usage{
seqPal(n = 12, reverse = FALSE, alpha = 1, extr = FALSE, yb = FALSE,
  yr = FALSE, colors = NULL, ...)
}
\arguments{
\item{n}{Number of colors. DEFAULT: 12}

\item{reverse}{Reverse colors? DEFAULT: FALSE}

\item{alpha}{Transparency (0=transparent, 1=fully colored). DEFAULT: 1}

\item{extr}{Should colors span possible range more extremely? 
If TRUE, it has very light yellow and very dark blue values included, 
using the result from \code{RColorBrewer::brewer.pal(9, "YlGnBu")}. DEFAULT: FALSE}

\item{yb}{Should colors be in yellow-blue instead of the internal (nice) default? DEFAULT: FALSE}

\item{yr}{Should colors be in yellow-red instead of the default? DEFAULT: FALSE}

\item{colors}{If not NULL, a color vector used in \code{\link{colorRampPalette}}. DEFAULT: NULL}

\item{\dots}{Further arguments passed to \code{\link{colorRamp}}}
}
\value{
Character string vector with color names
}
\description{
Sequential color palette from yelow to red or yellow to blue or custom colors.
}
\examples{

plot(rep(1,12),  pch=16, cex=5, col=seqPal(12), xaxt="n")
showPal()
 
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2016
}
\seealso{
\code{\link{showPal}}, \code{\link{divPal}}, \code{\link{addAlpha}}, 
         \code{\link{colorRampPalette}}, package \code{RColorBrewer}
}
\keyword{color}
\keyword{dplot}

