% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcor.R
\name{rcor}
\alias{rcor}
\title{Spatially correlated random values}
\usage{
rcor(n, xmin, xmax, ymin, ymax, allplots = TRUE, zstart, zfun = rnorm, ...)
}
\arguments{
\item{n}{Number of randomly scattered points to be created}

\item{xmin}{Smallest x-coordinate}

\item{xmax}{Largest x-coordinate}

\item{ymin}{Smallest y-coordinate}

\item{ymax}{Largest y-coordinate}

\item{allplots}{Save all plots in dummy.pdf? DEFAULT: TRUE}

\item{zstart}{Vector of starting values for seeding some points, must be shorter than n}

\item{zfun}{A function for random noise creation, taking n as first argument. DEFAULT: rnorm}

\item{\dots}{Further arguments passed to zfun, like sd=3}
}
\description{
Generate random values, but with spatial correlation
}
\note{
This function is not yet running
}
\examples{
# ToDO: expand function + write examples

}
\author{
Berry Boesenkool, \email{berry-b@gmx.de}, Jan 2016
}
\references{
For regular grid fields, see: \url{http://santiago.begueria.es/2010/10/generating-spatially-correlated-random-fields-with-r/}
}

