% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reml.R
\name{lmerSummary}
\alias{lmerSummary}
\title{Derive VCA-Summary Table from an Object Fitted via Function \code{\link{lmer}}}
\usage{
lmerSummary(
  obj,
  VarVC = TRUE,
  terms = NULL,
  Mean = NULL,
  cov = FALSE,
  X = NULL,
  tab.only = FALSE
)
}
\arguments{
\item{obj}{(lmerMod) object as returned by function \code{\link{lmer}}}

\item{VarVC}{(logical) TRUE = the variance-covariance matrix of variance components will be approximated
following the Giesbrecht & Burns approach, FALSE = it will not be approximated}

\item{terms}{(character) vector, optionally defining the order of variance terms to be used}

\item{Mean}{(numeric) mean value used for CV-calculation}

\item{cov}{(logical) TRUE = in case of non-zero covariances a block diagonal matrix will be constructed,
FALSE = a diagonal matrix with all off-diagonal elements being equal to zero will be contructed}

\item{X}{(matrix) design matrix of fixed effects as constructed to meet VCA-package requirements}

\item{tab.only}{(logical) TRUE = will return only the VCA-results table as 'data.frame', argument 'VarVC' will 
be automatically set to 'FALSE' (see details)}
}
\value{
(list) still a premature 'VCA'-object but close to a "complete" 'VCA'-object
}
\description{
This function builds a variance components analysis (VCA) table
from an object representing a model fitted by function \code{\link{lmer}}
of the \code{lme4} R-package.
}
\details{
It applies the approximation of the variance-covariance
matrix of variance components according to Giesbrecht & Burns (1985) and uses this
information to approximate the degrees of freedom according to Satterthwaite
(see SAS PROC MIXED documentation option 'CL').

This function can be used to create a VCA-results table from almost any fitted 'lmerMod'-object, i.e. one can
apply it to a model fitted via function \code{\link{lmer}} of the \code{lme4}-package. The only 
additional argument that needs to be used is 'tab.only' (see examples).
}
\examples{
\dontrun{
# fit a model with a VCA-function first
data(VCAdata1)
fit0 <- remlVCA(y~(device+lot)/day/run, subset(VCAdata1, sample==5))
fit0

# fit the same model with function 'lmer' of the 'lme4'-package
library(lme4)
fit1 <- lmer(y~(1|device)+(1|lot)+(1|device:lot:day)+(1|device:lot:day:run),
subset(VCAdata1, sample==5))
lmerSummary(fit1, tab.only=TRUE)
}
}
\references{
Searle, S.R, Casella, G., McCulloch, C.E. (1992), Variance Components, Wiley New York

Giesbrecht, F.G. and Burns, J.C. (1985), Two-Stage Analysis Based on a Mixed Model: Large-Sample
Asymptotic Theory and Small-Sample Simulation Results, Biometrics 41, p. 477-486
}
\seealso{
\code{\link{remlVCA}}, \code{\link{remlMM}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
