test_that("Precision avoids interminable loop in LAP", {
  # Increase value of epsilon in nontrivially_less_than to avoid loop.
  spl636 <- structure(as.raw(c(0xfe, 0xfe, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb2, 0x92, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 
                               0x00, 0x90, 0x90, 0x90, 0x90, 0x90, 0x10, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x04, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x08, 0x08, 0x40, 0x00, 
                               0x00, 0xff, 0xff, 0xff, 0x85, 0x81, 0x01, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x80, 0x80, 0x80, 0x80, 
                               0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x7a, 
                               0x7a, 0x52, 0x42, 0x42, 0x42, 0x00, 0x10, 0x28, 0x28, 0x28, 0x28, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xfb, 
                               0xfb, 0x6b, 0x61, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 
                               0x21, 0x21, 0x21, 0x21, 0x21, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 
                               0x0a, 0x08, 0x00, 0x08, 0x08, 0x00, 0x02, 0x90, 0x90, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x90, 0x10, 0x00, 0x00, 0x80, 0x80, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0xff, 0xff, 0xed, 0x2c, 0x24, 
                               0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 
                               0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 
                               0x08, 0x00, 0x00, 0x00, 0xc1, 0xc1, 0x80, 0x00, 0x00, 0x00, 0x00, 
                               0x80, 0x41, 0x40, 0x40, 0x00, 0x01, 0x01, 0x12, 0x10, 0x10, 0x00, 
                               0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0x35, 0x35, 0x35, 
                               0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x35, 0x34, 0x34, 0x14, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x01, 
                               0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0xc2, 0xc2, 
                               0xc2, 0xc2, 0x00, 0x00, 0xc2, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 
                               0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0xff, 0xff, 0xfe, 0xf6, 0xe6, 0xa0, 0xa0, 0xa0, 0x20, 0x20, 0x20, 
                               0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x80, 0x00, 0x00, 0x00, 0x46, 0x46, 0x02, 0x02, 0x02, 0x02, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 
                               0x40, 0x40, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x08, 0x08, 
                               0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0xff, 0xdf, 0xdf, 
                               0xdf, 0xdf, 0xd6, 0xd6, 0xd6, 0xd6, 0x02, 0x02, 0x02, 0x02, 0x02, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 
                               0xd0, 0x90, 0x80, 0x10, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x20, 0x20, 0xff, 0xff, 0xfe, 0xfe, 0xf6, 0x74, 
                               0x74, 0x74, 0x74, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
                               0x04, 0x04, 0x70, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 
                               0x10, 0x60, 0x40, 0x40, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x82, 
                               0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 
                               0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x08, 
                               0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 
                               0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xde, 0x8a, 0x8a, 0x8a, 0x88, 
                               0x88, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 
                               0x44, 0x00, 0x00, 0x44, 0x44, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 
                               0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
                               0xfd, 0xfd, 0xfd, 0xfd, 0xb8, 0xb8, 0xa8, 0xa8, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x80, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x28, 0x08, 
                               0x00, 0x00, 0x10, 0x00, 0x45, 0x45, 0x45, 0x01, 0x01, 0x00, 0x00, 
                               0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xff, 0xff, 0xff, 0xce, 
                               0xcc, 0x8c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80, 0x80, 0x80, 
                               0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                               0x08, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x40, 
                               0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 
                               0x02, 0x00, 0x00, 0x00, 0x00, 0x31, 0x11, 0x01, 0x01, 0x01, 0x00, 
                               0x01, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 
                               0x00, 0x00, 0x00, 0x00)), .Dim = c(85L, 11L), .Dimnames = list(
                                 c("91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
                                   "101", "102", "103", "104", "105", "106", "107", "108", "109", 
                                   "110", "111", "112", "113", "114", "115", "116", "117", "118", 
                                   "119", "120", "121", "122", "123", "124", "125", "126", "127", 
                                   "128", "129", "130", "131", "132", "133", "134", "135", "136", 
                                   "137", "138", "139", "140", "141", "142", "143", "144", "145", 
                                   "146", "147", "148", "149", "150", "151", "152", "153", "154", 
                                   "155", "156", "157", "158", "159", "160", "161", "162", "163", 
                                   "164", "165", "166", "167", "168", "169", "170", "171", "172", 
                                   "173", "174", "175"), NULL), nTip = 88L,
                      tip.label = c("Plateosaurus_engelhardti", "Jobaria_tiguidensis", "Comahuesaurus_windhanseni", "Qiaowanlong_kangxii", 
                                    "Galvesaurus_herreroi", "Dicraeosaurus_hansemanni", "Cathartesaura_anaerobica", 
                                    "Losillasaurus_giganteus", "Rebbachisaurus_garasbae", "Mendozasaurus_neguyelap", 
                                    "Amygdalodon_patagonicus", "Chubutisaurus_insignis", "Baurutitan", 
                                    "Wintonotitan_wattsi", "Notocolossus", "Isisaurus_colberti", 
                                    "Giraffatitan_brancai", "Chinshakiangosaurus_chunghoensis", "Lessemsaurus_sauropoides", 
                                    "Nemegtosaurus_mongoliensis", "Lusotitan", "Camarasaurus", "Tastavinsaurus_sanzi", 
                                    "Cedarosaurus_weiskopfe", "Padillasaurus_leivaensis", "Rayososaurus_agrioensis", 
                                    "Barapasaurus_tagorei", "Abydosaurus_mcintoshi", "Suwassea_emiliae", 
                                    "Dreadnoughtus", "Venenosaurus_dicrocei", "Drusilasaura", "Demandasaurus_darwini", 
                                    "Patagotitan_mayoi", "Euhelopus_zdanskyi", "Quetecsaurus_rusconii", 
                                    "Turiasaurus_riodevensis", "Cetiosaurus_oxoniensis", "Malawisaurus_dixeyi", 
                                    "Neuquensaurus_australis", "Erketu_ellisoni", "Futalongkosaurus", 
                                    "Andesaurus_delgadoi", "Aeolosaurus_maximus", "Tapuiasaurus_macedoi", 
                                    "Omeisaurus", "Epachthosaurus_sciuttoi", "Brachytrachelopan_messai", 
                                    "Overosaurus", "Shunosaurus_lii", "Nigersaurus_taqueti", "Opisthocoelicaudia_skarzynskii", 
                                    "Sauroposeidon_proteles", "Antetonitrus_ingenipes", "Haplocanthosaurus_priscus", 
                                    "Bellusaurus_sui", "Zapalasaurus_bonapartei", "Alamosaurus_sanjuanensis", 
                                    "Europasaurus_holgeri", "Rapetosaurus_krausei", "Phuwiangosaurus_sirindhornae", 
                                    "Apatosaurus", "Limaysaurus_tessonei", "Ruyangosaurus_giganteus", 
                                    "Mussaurus_patagonicus", "Amargasaurus_cazaui", "Rinconsaurus", 
                                    "Tehuelchesaurus_benitezii", "Trigonosaurus_pricei", "MPEF_dash_PV_10606", 
                                    "Saltasaurus_loricatus", "Tazoudasaurus_naimi", "Bonitasaura_salgadoi", 
                                    "Isanosaurus_attavipachi", "Argentinosaurus_hunculensis", "Diplodocus", 
                                    "Amazonsaurus_maranhensis", "Barosaurus_lentus", "Ligabuesaurus_lenzai", 
                                    "Brachiosaurus_altithorax", "Puertasaurus", "Gongxianosaurus_shibeiensis", 
                                    "Patagosaurus_fariasi", "Histriasaurus_bocardeli", "Malarguesaurus_florenciae", 
                                    "Vulcanodon_karibaensis", "Muyelensaurus", "Mamenchisaurus"), class = "Splits")
  
  spl2180 <- structure(as.raw(c(0xfe, 0xfe, 0xfe, 0xfe, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0x96, 0x96, 0x96, 0x92, 0x02, 0x02, 0x02, 0x02, 0x02, 
                                0x02, 0x02, 0x00, 0x00, 0x90, 0x90, 0x90, 0x90, 0x10, 0x00, 0x00, 
                                0x00, 0x80, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x48, 0x08, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0xff, 0xff, 0xbd, 0xb9, 0xb9, 0xb9, 0x81, 0x81, 0x81, 0x80, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 
                                0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 
                                0x38, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 
                                0x00, 0x00, 0x04, 0x04, 0x42, 0x42, 0x00, 0x00, 0x00, 0xff, 0xfb, 
                                0xfb, 0xfb, 0xfb, 0xfb, 0x6b, 0x61, 0x61, 0x61, 0x21, 0x21, 0x21, 
                                0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x01, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x0a, 0x08, 0x08, 0x00, 0x90, 0x90, 0x90, 0x00, 
                                0x00, 0x00, 0x90, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0xff, 0xff, 0xff, 0xff, 0xef, 
                                0xed, 0x2c, 0x24, 0x24, 0x24, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 
                                0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 
                                0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x08, 0x08, 0x00, 0x00, 0xc1, 0xc1, 0x41, 0x40, 0x40, 0x00, 0x01, 
                                0x01, 0x80, 0x80, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0xff, 0xff, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 
                                0xf7, 0xf7, 0x35, 0x35, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x34, 0x14, 0x14, 0x14, 0x04, 0x04, 0x04, 0x04, 
                                0x10, 0x20, 0x00, 0x00, 0x01, 0x01, 0x00, 0xc2, 0xc2, 0xc2, 0xc2, 
                                0x00, 0x00, 0x00, 0xc2, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x80, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 
                                0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xf6, 0xe6, 0xe6, 0x66, 0x20, 
                                0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x46, 0x46, 0x02, 0x02, 0x02, 0x02, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x40, 
                                0x40, 0x80, 0x80, 0x80, 0x00, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x01, 0x01, 0x01, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xdf, 0xdf, 
                                0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xd6, 0xd6, 0xd2, 0x02, 
                                0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd0, 0xd0, 
                                0x90, 0x90, 0x90, 0x90, 0x80, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 
                                0x04, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x20, 0x20, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 
                                0xfe, 0xf6, 0xf6, 0xf6, 0x74, 0x74, 0x34, 0x04, 0x04, 0x04, 0x04, 
                                0x04, 0x04, 0x04, 0x04, 0x04, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 
                                0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40, 0x82, 0x02, 
                                0x02, 0x02, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
                                0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
                                0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 
                                0xdc, 0x88, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x10, 
                                0x00, 0x00, 0x44, 0x44, 0x44, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 
                                0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
                                0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xfd, 0xed, 0xed, 0xa8, 0xa8, 
                                0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 
                                0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x08, 
                                0x00, 0x00, 0x00, 0x45, 0x45, 0x45, 0x01, 0x00, 0x00, 0x00, 0x01, 
                                0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xff, 0xff, 0xfe, 0xfc, 
                                0xfc, 0xfc, 0xcc, 0xcc, 0xcc, 0xc4, 0x84, 0x84, 0x84, 0x84, 0x84, 
                                0x84, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x00, 0x00, 
                                0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x01, 
                                0x00, 0x01, 0x00, 0x00)), .Dim = c(85L, 11L), .Dimnames = list(
                                  c("91", "92", "93", "94", "95", "96", "97", "98", "99", "100", 
                                    "101", "102", "103", "104", "105", "106", "107", "108", "109", 
                                    "110", "111", "112", "113", "114", "115", "116", "117", "118", 
                                    "119", "120", "121", "122", "123", "124", "125", "126", "127", 
                                    "128", "129", "130", "131", "132", "133", "134", "135", "136", 
                                    "137", "138", "139", "140", "141", "142", "143", "144", "145", 
                                    "146", "147", "148", "149", "150", "151", "152", "153", "154", 
                                    "155", "156", "157", "158", "159", "160", "161", "162", "163", 
                                    "164", "165", "166", "167", "168", "169", "170", "171", "172", 
                                    "173", "174", "175"), NULL), nTip = 88L, 
                       tip.label = c("Plateosaurus_engelhardti", "Jobaria_tiguidensis", "Comahuesaurus_windhanseni", "Qiaowanlong_kangxii", 
                                     "Galvesaurus_herreroi", "Dicraeosaurus_hansemanni", "Cathartesaura_anaerobica", 
                                     "Losillasaurus_giganteus", "Rebbachisaurus_garasbae", "Mendozasaurus_neguyelap", 
                                     "Amygdalodon_patagonicus", "Chubutisaurus_insignis", "Baurutitan", 
                                     "Wintonotitan_wattsi", "Notocolossus", "Isisaurus_colberti", 
                                     "Giraffatitan_brancai", "Chinshakiangosaurus_chunghoensis", "Lessemsaurus_sauropoides", 
                                     "Nemegtosaurus_mongoliensis", "Lusotitan", "Camarasaurus", "Tastavinsaurus_sanzi", 
                                     "Cedarosaurus_weiskopfe", "Padillasaurus_leivaensis", "Rayososaurus_agrioensis", 
                                     "Barapasaurus_tagorei", "Abydosaurus_mcintoshi", "Suwassea_emiliae", 
                                     "Dreadnoughtus", "Venenosaurus_dicrocei", "Drusilasaura", "Demandasaurus_darwini", 
                                     "Patagotitan_mayoi", "Euhelopus_zdanskyi", "Quetecsaurus_rusconii", 
                                     "Turiasaurus_riodevensis", "Cetiosaurus_oxoniensis", "Malawisaurus_dixeyi", 
                                     "Neuquensaurus_australis", "Erketu_ellisoni", "Futalongkosaurus", 
                                     "Andesaurus_delgadoi", "Aeolosaurus_maximus", "Tapuiasaurus_macedoi", 
                                     "Omeisaurus", "Epachthosaurus_sciuttoi", "Brachytrachelopan_messai", 
                                     "Overosaurus", "Shunosaurus_lii", "Nigersaurus_taqueti", "Opisthocoelicaudia_skarzynskii", 
                                     "Sauroposeidon_proteles", "Antetonitrus_ingenipes", "Haplocanthosaurus_priscus", 
                                     "Bellusaurus_sui", "Zapalasaurus_bonapartei", "Alamosaurus_sanjuanensis", 
                                     "Europasaurus_holgeri", "Rapetosaurus_krausei", "Phuwiangosaurus_sirindhornae", 
                                     "Apatosaurus", "Limaysaurus_tessonei", "Ruyangosaurus_giganteus", 
                                     "Mussaurus_patagonicus", "Amargasaurus_cazaui", "Rinconsaurus", 
                                     "Tehuelchesaurus_benitezii", "Trigonosaurus_pricei", "MPEF_dash_PV_10606", 
                                     "Saltasaurus_loricatus", "Tazoudasaurus_naimi", "Bonitasaura_salgadoi", 
                                     "Isanosaurus_attavipachi", "Argentinosaurus_hunculensis", "Diplodocus", 
                                     "Amazonsaurus_maranhensis", "Barosaurus_lentus", "Ligabuesaurus_lenzai", 
                                     "Brachiosaurus_altithorax", "Puertasaurus", "Gongxianosaurus_shibeiensis", 
                                     "Patagosaurus_fariasi", "Histriasaurus_bocardeli", "Malarguesaurus_florenciae", 
                                     "Vulcanodon_karibaensis", "Muyelensaurus", "Mamenchisaurus"), class = "Splits")
  
  expect_gt(MutualClusteringInfoSplits(spl2180, spl2180), 0)
  expect_equal(MutualClusteringInfoSplits(spl2180, spl636), 
               MutualClusteringInfoSplits(spl636, spl2180))
})

test_that("LAPJV fails gracefully", {
  expect_equal(integer(0L), LAPJV(matrix(NA, 0, 0)))
  expect_error(LAPJV(1:10))
  expect_error(LAPJV(matrix(1, 3, 4)))
})

test_that("LAPJV doesn't crash", {
  matching <- LAPJV(matrix(c(2, 1, 1, 2), 2, 2))
  expect_equal(list(score = 2L, matching = 2:1), matching)
  
  prob1 <- matrix(c(0.961725,0.987491,0.998668,0.987491,0.961725,0.909537,0.94122,0.94122,0.995114,0.998918,0.983687,0.998918,0.995114,0.961725,0.961725,0.905982,0.894804,0.967235,0.927943,0.976313,0.998918,0.987491,0.987491,0.987491,0.950548,0.99657,0.992766,0.927943,0.983687,0.998668,0.998668,0.998668,0.983687,0.99657,0.992766,0.99657,0.950548,0.998668,0.998668,0.998668,0.781612,0.976313,0.99657,0.967235,0.894804,0.987491,0.987491,0.86522,0.848783,0.998918,0.983687,0.998918,0.995114,0.961725,0.961725,0.905982,0.905982,0.987491,0.998668,0.987491,0.961725,0.909537,0.94122,0.94122)
                 , 8, 8)

  lap1 <- LAPJV(t(prob1))
  prob2 <- matrix(c(4331226503423491,4447263344615913,4497602557256872,4447263344615913,4331226503423491,4096188537649521,4238877126856984,4238877126856984,4481594300586206,4498725985366606,4430131659835512,4498725985366607,4481594300586207,4331226503423489,4331226503423489,4080180280978857,4029841068337899,4356037396159145,4179085437390878,4396924131974953,4498725985366607,4447263344615912,4447263344615912,4447263344615912,4280887290782531,4488150080431723,4471018395651321,4179085437390879,4430131659835511,4497602557256871,4497602557256871,4497602557256871,4430131659835512,4488150080431723,4471018395651321,4488150080431722,4280887290782531,4497602557256870,4497602557256870,4497602557256870,3520069415493380,4396924131974953,4488150080431722,4356037396159145,4029841068337899,4447263344615912,4447263344615912,3896604955955584,3822578278688707,4498725985366607,4430131659835512,4498725985366607,4481594300586207,4331226503423491,4331226503423491,4080180280978857,4080180280978857,4447263344615912,4497602557256870,4447263344615912,4331226503423489,4096188537649521,4238877126856985,4238877126856985)
                 , 8, 8)
  expect_equal(LAPJV(prob2)$score / max(prob2) * max(prob1), lap1$score, 
               tolerance = 1e-06)
})

test_that("Avoid infinite loop in LAP", {
  library('TreeTools')
  tree1 <- PectinateTree(11L)
  tree2 <- as.phylo(18253832, 11L)
  owch <- 1927
  set.seed(0)
  randomTreeId <- unique(floor(runif(owch * 2) * NUnrooted(11)))[seq_len(owch)][owch]
  
  expect_equal(134.7911 / 11L, # What the function tells me is the right answer
               ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(18253832, 11L)),
               tolerance = 0.01) 
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(12848772, 11L)))
  
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      Cladewise(Postorder(Preorder(ape::as.phylo(9850364, 11L))))
  ))
  
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(9850364, 11L)))
})
