% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation-EM.R
\name{FitBNEM}
\alias{FitBNEM}
\title{Fit Bivariate Normal Regression Model via Expectation Maximization.}
\usage{
FitBNEM(
  t,
  s,
  X,
  Z,
  sig = 0.05,
  b0 = NULL,
  a0 = NULL,
  sigma0 = NULL,
  maxit = 100,
  eps = 1e-06,
  report = TRUE
)
}
\arguments{
\item{t}{Target outcome vector.}

\item{s}{Surrogate outcome vector.}

\item{X}{Target model matrix.}

\item{Z}{Surrogate model matrix.}

\item{sig}{Type I error level.}

\item{b0}{Initial target regression coefficient.}

\item{a0}{Initial surrogate regression coefficient.}

\item{sigma0}{Initial covariance matrix.}

\item{maxit}{Maximum number of parameter updates.}

\item{eps}{Minimum acceptable improvement in log likelihood.}

\item{report}{Report fitting progress?}
}
\value{
An object of class 'bnr' with slots containing the estimated
  regression coefficients, the target-surrogate covariance matrix, the
  information matrices for the regression and covariance parameters, and the
  residuals.
}
\description{
Estimation procedure for bivariate normal regression models in which
the target and surrogate outcomes are both subject to missingness.
}
\details{
The target and surrogate model matrices are expected in numeric format.
Include an intercept if required. Expand factors and interactions in advance.
Initial values may be specified for any of the target coefficient
\code{b0}, the surrogate coefficient \code{a0}, or the target-surrogate
covariance matrix \code{sigma0}.
}
