% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{turinTess}
\alias{turinTess}
\title{Municipalities' administrative borders for Turin urban data.}
\format{
A \code{list} of three:
\itemize{
\item \code{tiles} a \code{list} of 15, each element is a \code{owin} object with the
administrative border of one municipality of Turin's dataset
\item \code{n} the number of municipalities
\item \code{names} the names of the 15 municipalities, in the same order as the windows
}
}
\source{
EEA (2011). Corine land cover 2000 raster data. Technical Report, downloadable at
http://www.eea.europa.eu/data-and-maps/ data/corine-land-cover-2000-raster-1
}
\usage{
turinTess
}
\description{
City borders of all municipalities included in the Turin dataset, in the formato of polyognal \code{owin} objects.
}
\details{
This is a list of 15 observation windows created as \code{owin} objects based on the coordinates of the border polygons, for each municipality.
See \code{?owin} for details.
The list also contains the names of the municipalities, in Italian.
Examples on the usefulness of the administrative borders can be found at the topi \link{turin}.
}
\examples{
plot(turinW, col=c("black", "white"), main="")
plot(turinTess$tiles[[1]],border=2, add=TRUE, lwd=2)
for(ll in 2:turinTess$n) plot(turinTess$tiles[[ll]],border=2, add=TRUE, lwd=2)

plot(as.im(turin, W=turinW), main="", col=gray(c(0.8,0)), ribbon=FALSE)
plot(turinTess$tiles[[1]],border=2, add=TRUE, lwd=2)
for(ll in 2:turinTess$n) plot(turinTess$tiles[[ll]],border=2, add=TRUE, lwd=2)

#see examples under the topic "turin"
}
\keyword{datasets}
