% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPheno.R
\name{specify.pars}
\alias{specify.pars}
\title{Get the parameters of main/epistatic effects per phenotype}
\usage{
specify.pars(genetic.pars, effect.type = c("main", "epistasis"),
  phe.index = 1, ...)
}
\arguments{
\item{genetic.pars}{a data.frame or a matrix containing the parameters
information for main effect: additive and dominance.}

\item{effect.type}{a string naming the type of the genetic effects
(accepts either "main" or "epistasis").}

\item{phe.index}{a integer indicating the phenotype. Default is 1.}

\item{...}{not used.}
}
\value{
a data.frame or a matrix containing the parameters information for epistatic effect:
additive  \eqn{\times}{*} additive,
additive  \eqn{\times}{*} dominance,
dominance \eqn{\times}{*} additive,
dominance \eqn{\times}{*} dominance.
}
\description{
Get the parameters of main/epistatic effects per phenotype.
}
\examples{
# get parameters of coefficients for main effects
specify.pars(genepars, effect.type = "main")

# get parameters of coefficients for interactive effects
specify.pars(genepars, effect.type = "epistasis")
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de}
}
