% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tva.R
\name{model_code}
\alias{model_code}
\alias{model_code,stanmodel-method}
\alias{model_code,stanfit-method}
\title{Extract Stan code}
\usage{
model_code(object, type)

\S4method{model_code}{stanmodel}(object, type = c("stan", "stan2", "cpp"))

\S4method{model_code}{stanfit}(object, type)
}
\arguments{
\item{object}{A StanTVA model object or fit.}

\item{type}{The type of code to return (\code{stan}: formatted StanTVA, \code{stan2}: ready-to-compile Stan code, \code{cpp}: generated C++ code).}
}
\value{
A RStanTVA model code object (\code{stan}), or a string containing the code (\code{stan2} or \code{cpp}).
}
\description{
Extracts the Stan code from a StanTVA model object.
}
\section{Methods (by class)}{
\itemize{
\item \code{model_code(stanmodel)}: method

\item \code{model_code(stanfit)}: Extract code from a model fit

}}
\examples{
\donttest{
model <- stantva_model(locations = 2)
model_code(model)
}
}
