% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetElements.R
\name{GetElements}
\alias{GetElements}
\title{Get Valid Elements for a Report Suite}
\usage{
GetElements(reportsuite.ids, metrics = c(), elements = c(),
  date.granularity = "", report.type = "")
}
\arguments{
\item{reportsuite.ids}{Single report suite id, or character vector of report suite ids}

\item{metrics}{List of existing metrics you want to use in combination with an additional element}

\item{elements}{List of existing elements you want to use in combination with an additional element}

\item{date.granularity}{Granularity that you want to combine with an additional metric}

\item{report.type}{If set to 'warehouse', the elements and metrics returned to use in combination with an addional element
are supported in data warehouse reports.}
}
\value{
Data frame
}
\description{
Get valid elements for a report suite for the current user.
This list is restricted by optionally specified existing elements, existing metrics and date granularity.
}
\details{
This function requires a character vector with one or more valid Report Suites specified.
}
\examples{
\dontrun{
elements.valid <- GetElements("your_report_suite",
                              metrics=c('visitors','pageviews'),
                              elements=c('page','geoCountry'),
                              date.granularity='day',
                              report.type='')

elements <- GetElements(c("your_prod_report_suite","your_dev_report_suite"))
}
}

