% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiSuccessionPlot}
\alias{MultiSuccessionPlot}
\title{Successive Phases Density Plots (for phases in temporal order constraint)}
\usage{
MultiSuccessionPlot(data, position_beginning, position_end = position_beginning+1,
 level = 0.95, title = "Phases marginal posterior densities")
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm }
  \item{position_beginning}{numeric vector containing the column number corresponding to the beginning of the phases}
  \item{position_end}{numeric vector containing the column number corresponding to the end of the phases. By default, position_end = position_beginning + 1. 
}
  \item{level}{probability corresponding to the level of confidence}
  \item{title}{title of the graph}
}
\value{
Returns a plot of all densities and adds several summary statistics
}
\description{
This functions draws a plot of the densities of several successive phases and adds several statistics (mean, CI, HPDR)
}
\details{
For each i, PhaseTimeRange computes the time range interval for the phase defined by its beginning position_beginning[i] and its end position_end[i]. 
The default value of position_end corresponds to CSV files exported from ChronoModel software. 
Transition ranges and gap ranges are represented by two-coloured segments using the colors of the both phases in succession. 
If the gap between two successive phases does not exist, a cross is drawn instead of a segment. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  
  # List of the name of the phases 
  names(Phases)
  
  # Stipulating position_end
  MultiSuccessionPlot(Phases, c(4,2), c(5,3), title = "Succession of phase 1 and phase 2")
  
  # In this case, equivalent to 
  MultiSuccessionPlot(Phases, c(4,2), title = "Succession of phase 1 and phase 2")
}
\keyword{ marginal posterior density }
\keyword{ gap between two phases }
\keyword{ transition between two phases }
\keyword{ phase time range }
\keyword{ temporal order }
