% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08coercion.r
\docType{methods}
\name{PTTrack-method}
\alias{PTTrack,PTModule,numeric,numeric-method}
\alias{PTTrack,PTPattern,numeric,missing-method}
\alias{PTTrack,character,missing,missing-method}
\alias{PTTrack,matrix,missing,missing-method}
\alias{PTTrack,numeric,missing-method}
\alias{PTTrack,raw,missing,missing-method}
\alias{PTTrack-method}
\alias{PTTrack<-}
\alias{PTTrack<-,PTModule,numeric,numeric,PTTrack-method}
\alias{PTTrack<-,PTPattern,numeric,missing,PTTrack-method}
\alias{PTTrack<-,numeric,missing,PTTrack-method}
\title{Coerce to or replace PTTrack}
\usage{
\S4method{PTTrack}{raw,missing,missing}(x)

\S4method{PTTrack}{matrix,missing,missing}(x)

\S4method{PTTrack}{character,missing,missing}(x)

\S4method{PTTrack}{PTModule,numeric,numeric}(x, track, pattern)

\S4method{PTTrack}{PTModule,numeric,numeric,PTTrack}(x, track, pattern) <- value

\S4method{PTTrack}{PTPattern,numeric,missing}(x, track)

\S4method{PTTrack}{PTPattern,numeric,missing,PTTrack}(x, track) <- value
}
\arguments{
\item{x}{Object (any of \code{raw} data, a 64 by 4 \code{matrix} of \code{raw}
data, a vector of \code{character} strings,
a \code{PTPattern} or a \code{PTModule})
to coerce to a \code{\link{PTTrack}}. See details below for the
required format of \code{x}}

\item{track}{When \code{x} is a \code{PTPattern},
or a \code{PTModule}, provide an index [1,4] of the track that needs
to be coerced to a \code{PTTrack}.}

\item{pattern}{When \code{x} is a \code{PTModule}, provide an index
of the pattern that needs to be coerced to a \code{PTTrack}. Note that
ProTracker uses indices for patterns that start at zero, whereas R uses indices
that start at one. Hence add one to an index obtained from a \code{PTModule}
object (e.g., \code{x$pattern.order})}

\item{value}{An object of \code{\link{PTTrack}} with which the \code{\link{PTTrack}}
object at the specified indices in object \code{x} needs to be replaced.}
}
\value{
When \code{PTTrack} is used, a \code{PTTrack} object
based on \code{x} is returned.

When \code{PTTrack<-} is used, object \code{x} is returned in which
the selected \code{PTTrack} is replaced with \code{value}.
}
\description{
This method will coerce a set of objects to a \code{PTTrack} object. It can also
be used to select specific tracks from \code{PTModule} and
\code{PTPattern} objects and replace the selected \code{PTTrack}.
}
\details{
Method to coerce \code{x} to class \code{\link{PTTrack}}.

When \code{x} is a 64 by 4 \code{matrix} of \code{raw} data, each row
implicitly represents a \code{\link{PTCell}} object and should
be formatted accordingly. See \code{\link{PTCell-class}} documentation for
more details.

When \code{x} is a 64 element \code{vector} of \code{character} representation
of \code{\link{PTCell}} objects, the \code{character} representation must be
conform the specifications as documented at the \code{\link{PTCell-class}}.

When \code{x} is of class \code{\link{PTPattern}}, or
\code{\link{PTModule}}, the \code{PTTrack} at the specified indices
(\code{track} and \code{pattern}) is returned, or can be replaced.
}
\examples{
## This will create an 'empty' PTTrack with all nul
## values, which is equivalent to new("PTTrack"):
PTTrack(as.raw(0x00))

## This will generate a PTTrack from a repeated
## character representation of a PTCell:
chan <- PTTrack(rep("C-3 01 C20", 64))

data("mod.intro")

## This will replace the PTTrack at pattern
## number 1, track number 2 of mod.intro with chan:
PTTrack(mod.intro, 2, 1) <- chan

}
\author{
Pepijn de Vries
}
\seealso{
Other track.operations: \code{\link{as.character}}
}

