% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/auxfuns.R
\name{approxB}
\alias{approxB}
\alias{getZ}
\alias{alphaLBound}
\alias{alphaGrad}
\alias{auxfuns}
\alias{.cbind.fill}
\alias{.scaleVars}
\alias{.transf_muvar}
\alias{.bar.legend}
\alias{.mpower}
\alias{.findPerm}
\alias{.transf}
\alias{.compute.alpha}
\alias{.vcovBeta}
\alias{.e.pi}
\alias{.initPi}
\title{Internal functions and generics for \code{mmsbm} package}
\usage{
approxB(y, d_id, pi_mat, directed = TRUE)

getZ(pi_mat)

alphaLBound(par, tot_nodes, c_t, x_t, s_mat, t_id, var_beta, mu_beta)

alphaGrad(par, tot_nodes, c_t, x_t, s_mat, t_id, var_beta, mu_beta)

.cbind.fill(...)

.scaleVars(x, keep_const = TRUE)

.transf_muvar(orig, is_var, is_array, des.mat, nblock = NULL, nstate = NULL)

.bar.legend(colPalette, range)

.mpower(mat, p)

.findPerm(block_list, target_mat = NULL, use_perms = TRUE)

.transf(mat)

.compute.alpha(X, beta)

.vcovBeta(
  all_phi,
  beta_coef,
  n.sim,
  n.blk,
  n.hmm,
  n.nodes,
  n.periods,
  mu.beta,
  var.beta,
  est_kappa,
  t_id_n,
  X
)

.e.pi(alpha_list, kappa, C_mat = NULL)

.initPi(
  soc_mats,
  dyads,
  edges,
  nodes_pp,
  dyads_pp,
  n.blocks,
  periods,
  directed,
  ctrl
)
}
\arguments{
\item{y, d_id, pi_mat, directed}{Internal arguments for blockmodel approximation.}

\item{par}{Vector of parameter values.}

\item{tot_nodes}{Integer vector; total number of nodes each node interacts with.}

\item{c_t}{Integer matrix; samples from Poisson-Binomial counts of a node instantiating a group.}

\item{x_t}{Numeric matrix; transposed monadic design matrices.}

\item{s_mat}{Integer matrix; Samples of HMM states by time period.}

\item{t_id}{Integer vector; for each node, what time-period is it observed in? zero-indexed.}

\item{mu_beta, var_beta}{Numeric arrays; prior mean and variances of monadic coefficients.}

\item{...}{Numeric vectors; vectors of potentially different length to be cbind-ed.}

\item{x, keep_const}{Internal arguments for matrix scaling.}

\item{orig}{Object to be transformed.}

\item{is_var}{Boolean. Is the object to be transformed a variance term?}

\item{is_array}{Boolean. Is the object to be transformed an array?}

\item{des.mat}{Numeric matrix. Design matrix corresponding to transformed object.}

\item{nblock}{Number of groups in model, defaults to \code{NULL}.}

\item{nstate}{Number of hidden Markov states in model, defaults to \code{NULL}.}

\item{colPalette}{A function produced by \code{colorRamp}.}

\item{range}{The range of values to label the legend.}

\item{mat}{Numeric matrix.}

\item{p}{Numeric scalar; power to raise matrix to.}

\item{block_list}{List of matrices; each element is a square, numeric matrix 
that defines a blockmodel,}

\item{target_mat}{Numeric matrix; reference blockmodel that those in block_list should 
be aligned to. Optional, defaults to \code{NULL}.}

\item{use_perms}{Boolean; should all row/column permutations be explored when
realigning matrices? defaults to \code{TRUE}.}

\item{X}{Numeric matrix; design matrix of monadic predictors.}

\item{beta}{Numeric array; array of coefficients associated with monadic predictors. 
It of dimensions Nr. Predictors by Nr. of Blocks by Nr. of HMM states.}

\item{all_phi, beta_coef, n.sim, n.blk, n.hmm, n.nodes, n.periods, mu.beta, var.beta, est_kappa, t_id_n, }{Additional internal arguments for covariance estimation.}

\item{alpha_list}{List of mixed-membership parameter matrices.}

\item{kappa}{Numeric matrix; matrix of marginal HMM state probabilities.}

\item{C_mat}{Numeric matrix; matrix of posterior counts of block instantiations per node.}

\item{soc_mats, dyads, edges, nodes_pp, dyads_pp, n.blocks, periods, ctrl}{Internal arguments for MM computation.}
}
\value{
See individual return section for each function:
\describe{
      \item{.cbind.fill}{Matrix of \code{cbind}'ed elements in \code{...}, with missing values in each vector filled with \code{NA}.}
      \item{.mpower}{Matrix; the result of raising \code{mat} to the \code{p} power.}
      \item{.findPerm}{List of permuted blockmodel matrices.}
      \item{.transf}{Matrix with transformed mixed-membership vectors along its rows, s.t. no element is equal to 0.0 or 1.0.}
      \item{.compute.alpha}{List of predicted alpha matrices, one element per HMM state.}
      \item{.e.pi}{Matrix of predicted mixed-membership vectors along its rows, with expectation computed over marginal 
                    distribution over HMM states for each time period.}
      \item{.missing}{Transformed data.frame with missing values list-wise deleted, or expanded
                      with missing indicator variables.}
      \item{.createSocioB}{List of sociomatrices.}
      \item{.vertboot2}{List of bootstrapped sociomatrices.}
    }
}
\description{
These are various utilities and generic methods used by 
the main package function.
}
\details{
These functions are meant for internal use only.
}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
