% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_initializeExisting.R
\name{table_initializeExisting}
\alias{table_initializeExisting}
\title{Converts an existing table into a known location table}
\usage{
table_initializeExisting(
  tbl = NULL,
  stateDataset = "NaturalEarthAdm1",
  countryCodes = NULL,
  radius = NULL,
  verbose = TRUE
)
}
\arguments{
\item{tbl}{Table of spatial locations that will be converted into a "known
location" table.}

\item{stateDataset}{Name of spatial dataset to use for determining state
codes, Default: 'NaturalEarthAdm1'}

\item{countryCodes}{Vector of country codes used to optimize spatial
searching. (See ?MazamaSpatialUtils::getStateCode())}

\item{radius}{Radius in meters, Default: NULL}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Known location tibble with the specified metadata columns. Any 
locations whose circles (as defined by \code{radius}) overlap will generate
warning messages. 

It is incumbent upon the user to address these issue by one of:

\enumerate{
\item{reduce the radius until no overlaps occur}
\item{assign one of the overlapping locations to the other location}
}
}
\description{
An existing table may have much of the data that is needed
for a known location table. This function accepts an incoming table and
searches for required columns:

\itemize{
\item{locationID}
\item{locationName}
\item{longitude}
\item{latitude}
\item{elevation}
\item{countryCode}
\item{stateCode}
\item{county}
\item{timezone}
\item{houseNumber}
\item{street}
\item{city}
\item{zip}
}

The \code{longitude} and \code{latitude} columns are required but all others
are optional.

If any of these optional columns are found, they will be used and the often 
slow and sometimes slightly inaccurate steps to generate that information
will be skipped. Any additional columns of information not part of the 
required list will be retained.

This method skips the assignment of columns like \code{elevation} and all
address related foe;ds that require web service requests.

Compared to initializing a brand new table and populating one record at a
time, this is a much faster way of creating a known location table from a
pre-existing table of metadata.
}
