% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{quartetCutMLE}
\alias{quartetCutMLE}
\title{Maximum likelihood estimate of quartet tree of blobs topology and CF under Cut model}
\usage{
quartetCutMLE(qcCF)
}
\arguments{
\item{qcCF}{a quartet count Concordance Factor (a 3-element vector)}
}
\value{
output with \code{output$topology} = 1, 2, or 3 indicating topology of
tree of blobs in accord with ordering of qcCF entries,
and \code{output$CFhat} the ML estimate for the CF
}
\description{
Computes Maximum likelihood estimate of quartet tree of blobs topology and CF under the Cut model of
\insertCite{ABMR24;textual}{MSCquartets}, Section 3. In case of ties, the topology and CF estimate are chosen randomly among those maximizing
the likelihood. In particular, a resolved tree of blobs is always returned.
}
\examples{
 quartetCutMLE(c(17,72,11))
 quartetCutMLE(c(48,11,41))
 quartetCutMLE(c(11,48,41))
 quartetCutMLE(c(48,41,11))

}
\references{
\insertRef{ABMR24}{MSCquartets}
}
