% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLnormParMix.R
\name{dLnormParMix}
\alias{dLnormParMix}
\title{density of a mixture of a lognormal and a Pareto r.v.}
\usage{
dLnormParMix(x, pi, mu, sigma, xmin, alpha)
}
\arguments{
\item{x}{non-negative numerical vector: values where the density has to be evaluated.}

\item{pi}{scalar, 0 < p < 1: mixing weight.}

\item{mu}{scalar: expected value of the lognormal distribution on the log scale.}

\item{sigma}{positive scalar: standard deviation of the lognormal distribution on the log scale.}

\item{xmin}{positive scalar: threshold.}

\item{alpha}{positive scalar: Pareto shape parameter.}
}
\value{
Density of the lognormal-Pareto distribution evaluated at x.
}
\description{
This function computes the density of a mixture of a lognormal and a Pareto r.v.
}
\examples{
mixDens <- dLnormParMix(5,.5,0,1,4,1.5)
}
\keyword{mixture.}
