/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.DataStructures.Data;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.omegahat.DataStructures.Data.AbstractVariable;
import org.omegahat.DataStructures.Data.BasicFactorLevelSet;
import org.omegahat.DataStructures.Data.FactorInt;
import org.omegahat.DataStructures.Data.FactorLevelSetInt;
import org.omegahat.DataStructures.Data.VariableInt;

public class FactorVariable
extends AbstractVariable
implements FactorInt,
Serializable {
    protected FactorLevelSetInt levels;
    protected int[] levelIndices;
    protected Object[] values;

    public FactorVariable() {
    }

    public FactorVariable(int n) {
        this.levelIndices = new int[n];
        this.levels = new BasicFactorLevelSet(1);
    }

    public FactorVariable(FactorVariable factorVariable) {
        this(factorVariable.toStringArray());
    }

    public FactorVariable(Object[] objectArray) {
        this(objectArray, objectArray.length);
    }

    public FactorVariable(Object[] objectArray, int n) {
        this(n);
        Vector vector = new Vector(1);
        if (objectArray != null) {
            this.levels(new BasicFactorLevelSet(objectArray));
        }
    }

    public FactorVariable(Object[] objectArray, int n, Hashtable hashtable) {
        this(objectArray, n);
        this.metaData(hashtable);
    }

    public void add(double d, int n) {
        this.add((int)d, n);
    }

    public void add(int n, int n2) {
        this.levelIndices[n2] = n;
    }

    public void add(Object object, int n) {
        int n2;
        if (this.levels == null) {
            this.levels(object);
        }
        if ((n2 = this.levels().indexOf(object)) < 0) {
            this.levels().add(object);
            n2 = this.levels().size() - 1;
        }
        if (n < 0 || this.levelIndices == null) {
            int n3 = 0;
            if (this.levelIndices != null) {
                n3 += this.levelIndices.length;
            }
            int[] nArray = new int[n3 + 1];
            if (n3 > 0) {
                System.arraycopy(this.levelIndices, 0, nArray, 0, n3);
            }
            this.levelIndices = nArray;
            this.levelIndices[n3] = n2;
        } else {
            this.levelIndices[n] = n2;
        }
    }

    public Object asArray() {
        return this.levels;
    }

    public Object asArrayCopy() {
        int[] nArray = new int[this.levelIndices.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.levelIndices[n];
            ++n;
        }
        return nArray;
    }

    protected Object[] computeValues() {
        int n = (int)this.numObservations();
        this.values = new Object[n];
        Object[] objectArray = this.levels.levels();
        int n2 = 0;
        while (n2 < n) {
            this.values[n2] = objectArray[this.levelIndices[n2]];
            ++n2;
        }
        return this.values;
    }

    public int getSize() {
        return this.levelIndices.length;
    }

    public double[] getValues() {
        int n = (int)this.numObservations();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.levelIndices[n2];
            ++n2;
        }
        return dArray;
    }

    public long[] indicesForLevel(Object object) {
        return null;
    }

    public Object[] labels() {
        return this.levels().levels();
    }

    public FactorLevelSetInt levels() {
        return this.levels;
    }

    public FactorLevelSetInt levels(Object object) {
        return this.levels(new BasicFactorLevelSet(object));
    }

    public FactorLevelSetInt levels(Vector vector) {
        return this.levels(new BasicFactorLevelSet(vector));
    }

    public FactorLevelSetInt levels(FactorLevelSetInt factorLevelSetInt) {
        this.levels = factorLevelSetInt;
        return this.levels();
    }

    public FactorLevelSetInt levels(String[] stringArray) {
        return this.levels(new BasicFactorLevelSet(stringArray));
    }

    public int numLevels() {
        return this.levels.size();
    }

    public long numObservations() {
        return this.levelIndices == null ? 0 : this.levelIndices.length;
    }

    public String toString() {
        String string = "Factor: # obs " + this.getSize() + " (# categories " + this.numLevels() + ")";
        return string;
    }

    public Object[] toStringArray() {
        int n = (int)this.numObservations();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.levels().elementAt(this.levelIndices[n2]);
            ++n2;
        }
        return objectArray;
    }

    public Object value(int n) {
        return this.levels().level(this.levelIndices[n]);
    }

    public Object[] values() {
        if (this.values == null) {
            this.computeValues();
        }
        return this.values;
    }

    public VariableInt values(int[] nArray) {
        FactorVariable factorVariable = new FactorVariable();
        factorVariable.levelIndices = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            factorVariable.levelIndices[n] = this.levelIndices[nArray[n]];
            ++n;
        }
        factorVariable.levelIndices = this.levelIndices;
        return factorVariable;
    }
}

