% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyPoissonNaiveBayes.R
\name{FuzzyPoissonNaiveBayes}
\alias{FuzzyPoissonNaiveBayes}
\title{Fuzzy Poisson Naive Bayes}
\usage{
FuzzyPoissonNaiveBayes(train, cl, cores = 2, fuzzy = TRUE)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}
}
\value{
A vector of classifications
}
\description{
\code{FuzzyPoissonNaiveBayes} Fuzzy Poisson Naive Bayes
}
\examples{

set.seed(1) # determining a seed
class1 <- data.frame(vari1 = rpois(100,lambda = 2),
                     vari2 = rpois(100,lambda = 2),
                     vari3 = rpois(100,lambda = 2), class = 1)
class2 <- data.frame(vari1 = rpois(100,lambda = 1),
                     vari2 = rpois(100,lambda = 1),
                     vari3 = rpois(100,lambda = 1), class = 2)
class3 <- data.frame(vari1 = rpois(100,lambda = 5),
                     vari2 = rpois(100,lambda = 5),
                     vari3 = rpois(100,lambda = 5), class = 3)
data <- rbind(class1,class2,class3)

# Splitting into Training and Testing
split <- caTools::sample.split(t(data[, 1]), SplitRatio = 0.7)
Train <- subset(data, split == "TRUE")
Test <- subset(data, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -4]
fit_NBT <- FuzzyPoissonNaiveBayes(
  train = Train[, -4],
  cl = Train[, 4], cores = 2
)

pred_NBT <- predict(fit_NBT, test)

head(pred_NBT)
head(Test[, 4])
}
\references{
\insertRef{moraes2015fuzzy}{FuzzyClass}
}
