% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBB_functions.R
\name{dFBB}
\alias{dFBB}
\alias{qFBB}
\alias{pFBB}
\alias{rFBB}
\title{The Flexible Beta-Binomial Distribution}
\usage{
dFBB(x, size, mu, theta = NULL, phi = NULL, p, w, log = FALSE)

qFBB(prob, size, mu, theta = NULL, phi = NULL, p, w, log.prob = FALSE)

pFBB(q, size, mu, theta = NULL, phi = NULL, p, w, log.prob = FALSE)

rFBB(n, size = NULL, mu, theta = NULL, phi = NULL, p, w)
}
\arguments{
\item{x, q}{a vector of quantiles.}

\item{size}{the total number of trials.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{theta}{the overdispersion parameter. It must  lie in (0, 1).}

\item{phi}{the precision parameter, an alternative way to specify the overdispersion parameter \code{theta}. It must be a real positive value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{w}{the normalized distance among component means. It must lie in (0, 1).}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{prob}{a vector of probabilities.}

\item{log.prob}{logical; if TRUE, probabilities \code{prob} are given as log(prob).}

\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
The function \code{dFBB} returns a vector with the same length as \code{x} containing the probability mass values.
The function \code{pFBB} returns a vector with the same length as \code{q} containing the values of the distribution function.
The function \code{qFBB} returns a vector with the same length as \code{prob} containing the quantiles.
The function \code{rFBB} returns a vector of length \code{n} containing the generated random values.
}
\description{
Mass function, distribution function, quantile function, and random generation
for the flexible beta-binomial distribution.
}
\details{
The FBB distribution is a special mixture of two beta-binomial distributions with probability mass function
\deqn{f_{FBB}(x;\mu,\phi,p,w) = p BB(x;\lambda_1,\phi)+(1-p)BB(x;\lambda_2,\phi),}
for \eqn{x \in \lbrace 0, 1, \dots, n \rbrace}, where \eqn{BB(x;\cdot,\cdot)} is the beta-binomial distribution with a mean-precision parameterization.
Moreover, \eqn{\phi=(1-\theta)/\theta>0} is a precision parameter, \eqn{0<p<1} is the mixing weight, \eqn{0<\mu=p\lambda_1+(1-p)\lambda_2<1} is the overall mean,
\eqn{0<w<1} is the  normalized distance between component means, and
\eqn{\lambda_1=\mu+(1-p)w} and \eqn{\lambda_2=\mu-pw} are the scaled means of the first and second component of the mixture, respectively.
}
\examples{
dFBB(x = c(5,7,8), size=10, mu = .3, phi = 20, p = .5, w = .5)
dFBB(x = c(5,7,8), size=10, mu = .3, theta = 1/(20+1), p = .5, w = .5)

qFBB(prob = .5, size=10, mu = .3, phi = 20, p = .5, w = .5)
qFBB(prob = .5, size=10, mu = .3, theta = 1/(20+1), p = .5, w = .5)

pFBB(q = c(5,7,8), size=10, mu = .3, phi = 20, p = .5, w = .5)
pFBB(q = c(5,7,8), size=10, mu = .3, theta = 1/(20+1), p = .5, w = .5)

rFBB(n = 100, size = 40, mu = .5, phi = 5, p = .3, w = .6)
rFBB(n = 100, size = 40, mu = .5, theta = 1/(5+1), p = .3, w = .6)

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005
}
}
