% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FB_functions.R
\name{dFB}
\alias{dFB}
\alias{qFB}
\alias{pFB}
\alias{rFB}
\title{The Flexible Beta Distribution}
\usage{
dFB(x, mu, phi, p, w, q0 = NULL, q1 = NULL, log = FALSE)

qFB(prob, mu, phi, p, w, q0 = NULL, q1 = NULL, log.prob = FALSE)

pFB(q, mu, phi, p, w, q0 = NULL, q1 = NULL, log.prob = FALSE)

rFB(n, mu, phi, p, w, q0 = NULL, q1 = NULL)
}
\arguments{
\item{x, q}{a vector of quantiles.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a real positive value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{w}{the normalized distance among component means. It must lie in (0, 1).}

\item{q0}{the probability of augmentation in zero. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{q1}{the probability of augmentation in one. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{log}{logical; if TRUE, densities are returned on log-scale.}

\item{prob}{a vector of probabilities.}

\item{log.prob}{logical; if TRUE, probabilities \code{prob} are given as log(prob).}

\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
The function \code{dFB} returns a vector with the same length as \code{x} containing the density values.
The function \code{pFB} returns a vector with the same length as \code{q} containing the values of the distribution function.
The function \code{qFB} returns a vector with the same length as \code{prob} containing the quantiles.
The function \code{rFB} returns a vector of length \code{n} containing the generated random values.
}
\description{
Density function, distribution function, quantile function, and random generation
for the (augmented) flexible beta distribution.
}
\details{
The FB distribution is a special mixture of two beta distributions with probability density function
\deqn{f_{FB}(x;\mu,\phi,p,w)=p f_B(x;\lambda_1,\phi)+(1-p)f_B(x;\lambda_2,\phi),}
for \eqn{0<x<1}, where \eqn{f_B(x;\cdot,\cdot)} is the beta density with a mean-precision parameterization.
Moreover, \eqn{0<\mu=p\lambda_1+(1-p)\lambda_2<1} is the overall mean, \eqn{\phi>0} is a precision parameter,
\eqn{0<p<1} is the mixing weight,  \eqn{0<w<1} is the  normalized distance between component means, and
\eqn{\lambda_1=\mu+(1-p)w} and \eqn{\lambda_2=\mu-pw} are the means of the first and second component of the mixture, respectively.

The augmented FB distribution has density
\itemize{
\item \eqn{q_0}, if \eqn{x=0}
\item \eqn{q_1}, if \eqn{x=1}
\item \eqn{(1-q_0-q_1)f_{FB}(x;\mu,\phi,p,w)}, if \eqn{0<x<1 }
}
where \eqn{0<q_0<1} identifies the augmentation in zero, \eqn{0<q_1<1} identifies the augmentation in one,
and \eqn{q_0+q_1<1}.
}
\examples{
dFB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5)
dFB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2)
dFB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2, q1 = .1)

qFB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5)
qFB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2)
qFB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2, q1 = .1)

pFB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5)
pFB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2)
pFB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, w = .5, q0 = .2, q1 = .1)

rFB(n = 100, mu = .5, phi = 30,p = .3, w = .6)
rFB(n = 100, mu = .5, phi = 30,p = .3, w = .6, q0 = .2, q1 = .1)

}
\references{
{
Di Brisco, A. M., Migliorati, S. (2020). A new mixed-effects mixture model for constrained longitudinal data. Statistics in Medicine, \bold{39}(2), 129--145. doi:10.1002/sim.8406 \cr
\cr
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079
}
}
