% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faasr_start.R
\name{faasr_start}
\alias{faasr_start}
\title{faasr_start}
\arguments{
\item{faasr_payload}{JSON Payload provided upon Action invocation by the FaaS platform}
}
\value{
faasr a list form of JSON payload
}
\description{
This is the entry-point FaaSr Function that is invoked by a FaaS platform when an Action is instantiated
Terminology to clarify the various modules involved:

* Action: an instance of a Docker container instantiated by a FaaS platform
* User Function: a single function written in R; at runtime, it is executed by a single Action
* FaaSr Function: function implemented by the FaaSr package to implement all the logic necessary to manage
    the execution of a User Function within an Action. A FaaSr function has a prefix faasr_
* User Workflow: a graph where each vertex represents a single User Functions and each edge represents a trigger
* Payload: a JSON-formatted text file that conforms to the FaaSr schema. It is delivered by the FaaS platform
    for each Action. It describes the entire User Workflow and may contain credentials for FaaS and S3 services

faasr_start calls other FaaSr Functions to go through the following steps:

* Parse the Payload and ensure that it conforms to the FaaSr JSON schema; otherwise, abort
* Build the User Workflow graph from Payload and ensure it is cycle-free; otherwise, abort
* Initialize the logs folder in an S3 bucket, only if this is the entry point to the User Workflow
* Ensure only a single User Function runs if it has multiple predecessors; otherwise, abort
* Invoke the User Function, supplying the parsed payload as a list argument
* Update the logs folder to assert that this User Function has completed
* Generate triggers to start Actions that will run the next User Functions, if there are any in the User Workflow
}
\examples{
# This function can be run only in the container
if (interactive()){
faasr <- faasr_start(faasr_payload)
}
}
