% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datSum_options.R
\name{datSum_options}
\alias{datSum_options}
\title{Options for summarizing tree data.}
\usage{
datSum_options(
  lbs2tons = TRUE,
  metric = FALSE,
  tround = 5,
  TPA = TRUE,
  adjTPA = 1,
  ACI = FALSE,
  adjtree = FALSE,
  adjvar = "tadjfac",
  NAto0 = TRUE,
  ...
)
}
\arguments{
\item{lbs2tons}{Logical. If TRUE, converts biomass or carbon variables from
pounds to tons (1 pound = 0.0005 short tons). If metric=TRUE, converts to  
metric tons, else short tons.}

\item{metric}{Logical. If TRUE, converts response to metric units based on
ref_conversion, if any variable in tsumvarlst is in
FIESTAutils::ref_estvar.  Note: if TPA, TPA is converted to trees per hectare
(TPH: (1/ tpavar * 0.4046860)).}

\item{tround}{Number. The number of digits to round to. If NULL, default=5.}

\item{TPA}{Logical. If TRUE, tsumvarlst variable(s) are multiplied by the
respective trees-per-acre variable (see details) to get per-acre
measurements.}

\item{adjTPA}{Numeric. A tree-per-acre adjustment. Use for DESIGNCD=1
(annual inventory), if using less than 4 subplots. If using only 1 subplot
for estimate, adjTPA=4. The default is 1.}

\item{ACI}{Logical. If TRUE, if ACI (All Condition Inventory) plots exist,
any trees on these plots will be included in summary. If FALSE, you must
include condition table.}

\item{adjtree}{Logical. If TRUE, trees are individually adjusted by
adjustment factors.  Adjustment factors must be included in tree table (see
adjvar).}

\item{adjvar}{String. If adjtree=TRUE, the name of the variable to use for
multiplying by adjustment (e.g., tadjfac).}

\item{NAto0}{Logical. If TRUE, change NA values to 0}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for 
summarizing tree data.
}
\description{
Returns a list of user-supplied parameters and parameter values for 
summarizing tree data.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

datSum_options(lbs2tons = TRUE, metric = TRUE)

}
\author{
Tracey S. Frescino
}
\keyword{options}
