% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDboostLSS.R
\name{cvrisk.FDboostLSS}
\alias{cvrisk.FDboostLSS}
\title{Cross-validation for FDboostLSS}
\usage{
\method{cvrisk}{FDboostLSS}(
  object,
  folds = cvLong(id = object[[1]]$id, weights = model.weights(object[[1]])),
  grid = NULL,
  papply = mclapply,
  trace = TRUE,
  fun = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{FDboostLSS}.}

\item{folds}{a weight matrix a weight matrix with number of rows equal to the number of observations. 
The number of columns corresponds to the number of cross-validation runs, 
defaults to 25 bootstrap samples, resampling whole curves}

\item{grid}{defaults to a grid up to the current number of boosting iterations. 
The default generates the grid according to the defaults of 
\code{\link{cvrisk.mboostLSS}} which are different for models with cyclic or noncyclic fitting.}

\item{papply}{(parallel) apply function, defaults to \code{\link{mclapply}}, 
see \code{\link{cvrisk.mboostLSS}} for details.}

\item{trace}{print status information during cross-validation? Defaults to \code{TRUE}.}

\item{fun}{if \code{fun} is \code{NULL}, the out-of-sample risk is returned. 
\code{fun}, as a function of \code{object}, 
may extract any other characteristic of the cross-validated models. These are returned as is.}

\item{...}{additional arguments passed to \code{\link{mclapply}}.}
}
\value{
An object of class \code{cvriskLSS} (when \code{fun} was not specified), 
basically a matrix containing estimates of the empirical risk for a varying number 
of bootstrap iterations. \code{plot} and \code{print} methods are available as well as an 
\code{mstop} method, see \code{\link{cvrisk.mboostLSS}}.
}
\description{
Multidimensional cross-validated estimation of the empirical risk for hyper-parameter selection, 
for an object of class \code{FDboostLSS} setting the folds per default to resampling curves.
}
\details{
The function \code{cvrisk.FDboostLSS} is a wrapper for 
\code{cvrisk.mboostLSS} in package \code{gamboostLSS}.  
It overrides the default for the folds, so that the folds are sampled on the level of curves 
(not on the level of single observations, which does not make sense for functional response).
}
\seealso{
\code{\link{cvrisk.mboostLSS}} in 
package \code{gamboostLSS}.
}
