% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\docType{methods}
\name{dbWriteTable,DatabaseConnectorConnection,character,data.frame-method}
\alias{dbWriteTable,DatabaseConnectorConnection,character,data.frame-method}
\title{Copy data frames to database tables}
\usage{
\S4method{dbWriteTable}{DatabaseConnectorConnection,character,data.frame}(conn,
  name, value, overwrite = FALSE, append = FALSE, temporary = FALSE,
  oracleTempSchema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying the unquoted DBMS table name,
or the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{value}{a \link{data.frame} (or coercible to data.frame).}

\item{overwrite}{Overwrite an existing table (if exists)?}

\item{append}{Append to existing table?}

\item{temporary}{Should the table created as a temp table?}

\item{oracleTempSchema}{Specifically for Oracle, a schema with write priviliges where temp tables
can be created.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbWriteTable()} returns \code{TRUE}, invisibly.
If the table exists, and both \code{append} and \code{overwrite} arguments are unset,
or \code{append = TRUE} and the data frame with the new data has different
column names,
an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
Invalid values for the additional arguments \code{row.names},
\code{overwrite}, \code{append}, \code{field.types}, and \code{temporary}
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate
or missing names,
incompatible columns)
also raise an error.
}
\description{
Writes, overwrites or appends a data frame to a database table, optionally
converting row names to a column and specifying SQL data types for fields.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbWriteTable")}
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}}
}
