% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.funnel_measure.R
\name{plot.funnel_measure}
\alias{plot.funnel_measure}
\title{Funnel plot for difference in measures}
\usage{
\method{plot}{funnel_measure}(x, ..., dot_size = 0.5)
}
\arguments{
\item{x}{- funnel_measure object created with \code{\link{funnel_measure}} function.}

\item{...}{- other parameters}

\item{dot_size}{- size of the dot on plots. Passed to \code{\link[ggplot2]{geom_point}}.}
}
\value{
ggplot object
}
\description{
Function \code{plot.funnel_measure} creates funnel plot of differences in measures for two models across variable areas.
It uses data created with 'funnel_measure' function.
}
\examples{
\donttest{
library("mlr")
library("DALEXtra")
task <- mlr::makeRegrTask(
  id = "R",
  data = apartments,
  target = "m2.price"
)
learner_lm <- mlr::makeLearner(
  "regr.lm"
)
model_lm <- mlr::train(learner_lm, task)
explainer_lm <- explain_mlr(model_lm, apartmentsTest, apartmentsTest$m2.price, label = "LM")

learner_rf <- mlr::makeLearner(
  "regr.randomForest"
)
model_rf <- mlr::train(learner_rf, task)
explainer_rf <- explain_mlr(model_rf, apartmentsTest, apartmentsTest$m2.price, label = "RF")

learner_gbm <- mlr::makeLearner(
  "regr.gbm"
)
model_gbm <- mlr::train(learner_gbm, task)
explainer_gbm <- explain_mlr(model_gbm, apartmentsTest, apartmentsTest$m2.price, label = "GBM")


plot_data <- funnel_measure(explainer_lm, list(explainer_rf, explainer_gbm),
                            nbins = 5, measure_function = DALEX::loss_root_mean_square)
plot(plot_data)
}
}
