% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostParams.R
\name{hostParams}
\alias{hostParams}
\title{Initialize for NlmeParallelHost}
\usage{
hostParams(
  sharedDirectory,
  installationDirectory = Sys.getenv("INSTALLDIR"),
  hostName = Sys.info()[["nodename"]],
  machineName = "127.0.0.1",
  hostType = Sys.info()[["sysname"]],
  numCores = 4,
  parallelMethod = "LOCAL_MPI",
  userName = "",
  privateKeyFile = NULL,
  userPassword = "",
  scriptPath = "",
  rLocation = "",
  isLocal = TRUE
)
}
\arguments{
\item{sharedDirectory}{Directory where temporary NLME run folder is created
during execution. If missing, the current working directory will be used.}

\item{installationDirectory}{Directory containing NLME libraries/scripts}

\item{hostName}{Visual name of the host (default A name by which
the machine is known on the network)}

\item{machineName}{IP address or name of the host(default
127.0.0.1)}

\item{hostType}{\code{windows} or \code{linux}. Current OS by default.
For remote runs it is possible to point
the distro suppported, i.e. \code{RHEL8} or \code{UBUNTU2204}. In such case the
corresponding \code{PML_BIN_DIR} variable will be created and NLME Engine libraries
will be looked in \verb{installationDirectory/\{$PML_BIN_DIR\}}.}

\item{numCores}{Integer; Number of compute cores. 4 by default}

\item{parallelMethod}{String; Options are:
\code{None}|\code{Multicore}|\code{LOCAL_MPI}|\code{SGE}|\code{SGE_MPI}|
\code{TORQUE}|\code{TORQUE_MPI}|\code{LSF}|\code{LSF_MPI}|\code{SLURM_SLURM_MPI}.}

\item{userName}{String; How the user is identified to the remote
system}

\item{privateKeyFile}{Path to private key file, see
\code{\link[ssh:ssh]{ssh::ssh_connect()}} for details}

\item{userPassword}{Either a string or a callback function for
password prompt, see \code{\link[ssh:ssh]{ssh::ssh_connect()}} for details}

\item{scriptPath}{a path to the script to be executed before
starting Rscript within Certara.NLME8 package on the remote host. Ignored
when running locally.}

\item{rLocation}{Path to Rscript executable on remote host;
ignored on local host}

\item{isLocal}{Is this a local \code{TRUE} or remote \code{FALSE} host?}
}
\value{
NlmeParallelHost class instance
}
\description{
Initialize for NlmeParallelHost
}
\examples{
host <- hostParams(sharedDirectory = tempdir(),
                   parallelMethod = "LOCAL_MPI",
                   hostName = "Local",
                   numCores = 4)

}
\keyword{NLME}
\keyword{NlmeParallelHost}
