% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedEffect.R
\name{fixedEffect}
\alias{fixedEffect}
\title{Specifies the initial values, lower bounds, upper bounds, and units for fixed effects in a model}
\usage{
fixedEffect(
  .Object,
  effect,
  value = NULL,
  lowerBound = NULL,
  upperBound = NULL,
  isFrozen = NULL,
  unit = NULL
)
}
\arguments{
\item{.Object}{Model object in which to define fixed effects values}

\item{effect}{Character or character vector specifying names of fixed effects}

\item{value}{Numeric or numeric vector specifying the initial values of fixed effects. If supplying vector, must be in the same order/length as corresponding \code{effect}.}

\item{lowerBound}{Numeric or numeric vector specifying the lower limit values of fixed effects. If supplying vector, must be in the same order as \code{effect}.}

\item{upperBound}{Numeric or numeric vector specifying the upper limit values of fixed effects. If supplying vector, must be in the same order as \code{effect}.}

\item{isFrozen}{Logical or logical vector. Set to \code{TRUE} to freeze the fixed effect to the specified initial value. If supplying vector, must be in the same order as \code{effect}.}

\item{unit}{Character or character vector specifying units of measurement for the fixed effects. If supplying a vector, must be in the same order as \code{effect}.}
}
\value{
Modified \code{NlmePmlModel} object
}
\description{
Specifies the initial values, lower bounds, upper bounds, and units for fixed effects in a model
}
\examples{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  modelName = "TwCpt_IVBolus_FOCE_ELS"
  )

 # View initial/current fixed effect values
 initFixedEffects(model)

model <- model |>
fixedEffect(
  effect = c("tvV", "tvCl", "tvV2", "tvCl2"),
  value = c(15, 5, 40, 15)
  )

}
