/*
 * Decompiled with CFR 0.152.
 */
package dr.app.beast;

import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BeastVersion
implements Version,
Citable {
    public static final BeastVersion INSTANCE = new BeastVersion();
    private static final String VERSION = "10.5.0";
    private static final String DATE_STRING = "2002-2025";
    private static final boolean IS_PRERELEASE = false;
    public static Citation[] CITATIONS = new Citation[]{new Citation(new Author[]{new Author("G", "Baele"), new Author("X", "Ji"), new Author("GW", "Hassler"), new Author("JT", "McCrone"), new Author("Y", "Shao"), new Author("Z", "Zhang"), new Author("AJ", "Holbrook"), new Author("P", "Lemey"), new Author("AJ", "Drummond"), new Author("A", "Rambaut"), new Author("MA", "Suchard")}, "BEAST X for Bayesian phylogenetic, phylogeographic and phylodynamic inference", 2025, "Nature Methods", "", "10.1038/s41592-025-02751-x")};

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getVersionString() {
        return "v10.5.0" + "";
    }

    @Override
    public String getDateString() {
        return DATE_STRING;
    }

    @Override
    public String[] getCredits() {
        return new String[]{"Designed and developed by", "Alexei J. Drummond, Andrew Rambaut and Marc A. Suchard", "", "Department of Computer Science", "University of Auckland", "alexei@cs.auckland.ac.nz", "", "Institute of Ecology and Evolution", "University of Edinburgh", "a.rambaut@ed.ac.uk", "", "David Geffen School of Medicine", "University of California, Los Angeles", "msuchard@ucla.edu", "", "Downloads, Help & Resources:", "\thttp://beast.community", "", "Source code distributed under the GNU Lesser General Public License:", "\thttp://github.com/beast-dev/beast-mcmc", "", "BEAST developers:", "\tAlex Alekseyenko, Daniel Ayres, Guy Baele, Trevor Bedford, Filip Bielejec, Erik Bloomquist, ", "\tLuiz Max Carvalho, Gabriela Cybis, Mandev Gill, Matthew Hall, Gabe Hassler, Joseph Heled, ", "\tSebastian Hoehna, Xiang Ji, Michael Karcher, Denise Kuehnert, Philippe Lemey, Wai Lok Sibon Li, ", "\tGerton Lunter, Andy Magee, Sidney Markowitz, JT McCrone, Volodymyr Minin, Julia Palacios, ", "\tMichael Defoin Platel, Oliver Pybus, Yucai Shao, Max Tolkoff, Chieh-Hsi Wu, Walter Xie and Zhenyu Zhang", "", "Thanks to:", "\tRoald Forsberg, Beth Shapiro and Korbinian Strimmer"};
    }

    @Override
    public String getHTMLCredits() {
        return "<p>Designed and developed by<br>Alexei J. Drummond, Andrew Rambaut and Marc A. Suchard</p><p>Department of Computer Science, University of Auckland<br>alexei@cs.auckland.ac.nz</p><p>Institute of Ecology and Evolution, University of Edinburgh<br>a.rambaut@ed.ac.uk</p><p>David Geffen School of Medicine, University of California, Los Angeles<br>msuchard@ucla.edu</p><p>BEAST website and documentation:<br><em>http://beast.community</em></p><p>Source code distributed under the GNU LGPL:<br><em>http://github.com/beast-dev/beast-mcmc</em></p><p>BEAST developers:<br>Alex Alekseyenko, Daniel Ayres, Guy Baele, Trevor Bedford, Filip Bielejec, Erik Bloomquist,<br>Luiz Max Carvalho, Gabriela Cybis, Mandev Gill, Matthew Hall, Gabe Hassler, Joseph Heled,<br>Sebastian Hoehna, Xiang Ji, Michael Karcher, Denise Kuehnert, Philippe Lemey, Wai Lok Sibon Li,<br>Gerton Lunter, Andy Magee, Sidney Markowitz, JT McCrone, Volodymyr Minin, Julia Palacios,<br>Michael Defoin Platel, Oliver Pybus, Yucai Shao, Max Tolkoff, Chieh-Hsi Wu, Walter Xie and Zhenyu Zhang</p><p>Thanks to Roald Forsberg, Beth Shapiro and Korbinian Strimmer</p>";
    }

    @Override
    public String getBuildString() {
        return "https://github.com/beast-dev/beast-mcmc/releases/tag/v" + this.getVersion();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.FRAMEWORK;
    }

    @Override
    public String getDescription() {
        return "BEAST primary citation";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(CITATIONS);
    }

    public static void main(String[] stringArray) {
        System.out.println(BeastVersion.getRevision());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRevision() {
        try (InputStream inputStream = BeastVersion.class.getResourceAsStream("/revision.txt");){
            if (inputStream != null) {
                List list = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                String string3 = (String)list.get(1);
                if (string3.endsWith("-dirty")) {
                    string3 = string3.substring(0, string3.length() - "-dirty".length());
                }
                String string2 = string3;
                return string2;
            }
            String string = "unknown";
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException("No revision file found. Try running `ant revision` to make it");
        }
    }
}

