% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-formula.R
\name{JAGS_formula}
\alias{JAGS_formula}
\title{Create JAGS formula syntax and data object}
\usage{
JAGS_formula(formula, parameter, data, prior_list)
}
\arguments{
\item{formula}{formula specifying the right hand side of the assignment (the
left hand side is ignored). If the formula contains \code{-1}, it will be
automatically converted to include an intercept with a spike(0) prior.}

\item{parameter}{name of the parameter to be created with the formula}

\item{data}{data.frame containing predictors included in the formula}

\item{prior_list}{named list of prior distribution of parameters specified within
the \code{formula}. When using \code{-1} in the formula, an "intercept" prior
can be explicitly specified; otherwise, \code{prior("spike", list(0))} is
automatically added.}
}
\value{
\code{JAGS_formula} returns a list containing the formula JAGS syntax,
JAGS data object, and modified prior_list.
}
\description{
Creates a JAGS formula syntax, prepares data input, and
returns modified prior list for further processing in the \code{JAGS_fit}
function.
}
\details{
When a formula with \code{-1} (no intercept) is specified, the
function automatically removes the \code{-1}, adds an intercept back to the
formula, and includes a spike(0) prior for the intercept to ensure equivalent
model behavior while maintaining consistent formula parsing.
}
\examples{
# simulate data
set.seed(1)
df <- data.frame(
  y      = rnorm(60),
  x_cont = rnorm(60),
  x_bin  = rbinom(60, 1, .5),
  x_fac3 = factor(rep(c("A", "B", "C"), 20), levels = c("A", "B", "C")),
  x_fac4 = factor(rep(c("A", "B", "C", "D"), 15), levels = c("A", "B", "C", "D"))
)

# specify priors with intercept
prior_list <- list(
"intercept"     = prior("normal", list(0, 1)),
"x_cont"        = prior("normal", list(0, .5)),
"x_fac3"        = prior_factor("normal",  list(0, 1),  contrast = "treatment"),
"x_fac4"        = prior_factor("mnormal", list(0, 1),  contrast = "orthonormal"),
"x_fac3:x_fac4" = prior_factor("mnormal", list(0, .5), contrast = "orthonormal")
)

# create the formula object
formula_obj <- JAGS_formula(
  formula = ~ x_cont + x_fac3 * x_fac4,
  parameter = "mu", data = df, prior_list = prior_list)

# using -1 notation (automatically adds spike(0) intercept)
prior_list_no_intercept <- list(
  "x_fac3" = prior_factor("normal", list(0, 1), contrast = "treatment")
)
formula_no_intercept <- JAGS_formula(
  formula = ~ x_fac3 - 1,
  parameter = "mu", data = df, prior_list = prior_list_no_intercept)
# Equivalent to specifying intercept = prior("spike", list(0))

}
\seealso{
\code{\link[=JAGS_fit]{JAGS_fit()}}
}
