% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/discover.R
\name{getEndpoints}
\alias{getEndpoints}
\title{Get Web Service Endpoints.}
\usage{
getEndpoints(wkID, authToken, wsID, url = prodURL)
}
\arguments{
\item{wkID}{workspace ID}

\item{authToken}{primary authorization token}

\item{wsID}{the web service ID}

\item{url}{the API url to make the call to, by default hits the Azure management API}
}
\value{
Returns a list of lists, where each endpoint is represented
as a nested named list with the following fields:

\itemize{
 \item Name
 \item Description
 \item CreationTime
 \item WorkspaceId
 \item WebServiceId
 \item HelpLocation
 \item PrimaryKey
 \item SecondaryKey
 \item ApiLocation
 \item Version
 \item MaxConcurrentCalls
 \item DiagnosticsTraceLevel
 \item ThrottleLevel
 }
}
\description{
Get the API endpoints that belong to a Microsoft Azure Machine Learning web service.
}
\examples{
\dontrun{
endpoints <- getEndpoints("wkId", "authToken", "wsID")
helpURL <- endpoints[[1]]$HelpLocation
pKey <- endpoints[[1]]$PrimaryKey
apiURL <- endpoints[[1]]$ApiLocation
}
}
\seealso{
\code{\link{publishWebService}} \code{\link{consumeLists}}

Other discovery functions: \code{\link{discoverSchema}};
  \code{\link{getEPDetails}}; \code{\link{getFramework}};
  \code{\link{getWSDetails}}; \code{\link{getWebServices}}
}

