% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_loadLatest.R
\name{sensor_loadLatest}
\alias{sensor_loadLatest}
\title{Load hourly-aggregated PurpleAir data for a week}
\usage{
sensor_loadLatest(collection = "scaqmd", days = 7)
}
\arguments{
\item{collection}{Name associated with the collection.}

\item{days}{Number of days of data to include (7 or 45).}
}
\value{
An object of class "pa_timeseries".
}
\description{
A pre-generated \code{airsensor} object will be loaded 
containing data for the most recent 7 or 45-day interval.

Each \code{airsensor} object contains data from a named collection of 
PurpleAir sensors.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

sensor_loadLatest("scaqmd") \%>\%
  PWFSLSmoke::monitor_timeseriesPlot(style = 'gnats')
}
}
\seealso{
\link{sensor_load}

\link{sensor_loadMonth}

\link{pat_createAirSensor}
}
