% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_filterDate.R
\name{pat_filterDate}
\alias{pat_filterDate}
\title{Date filtering for PurpleAir Timeseries objects}
\usage{
pat_filterDate(
  pat = NULL,
  startdate = NULL,
  enddate = NULL,
  days = NULL,
  weeks = NULL,
  timezone = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{days}{Number of days to include in the filterDate interval.}

\item{weeks}{Number of weeks to include in the filterDate interval.}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A subset of the given \emph{pat} object.
}
\description{
Subsets a PurpleAir Timeseries object by date. This function
always filters to day-boundaries. For sub-day filtering, use 
\code{pat_filterDatetime()}.

Dates can be anything that is understood by \code{lubridate::ymd()}
including either of the following recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}
}
\note{
The returned data will run from the beginning of \code{startdate} until
the \strong{beginning} of \code{enddate} -- \emph{i.e.} no values associated
with \code{enddate} will be returned. The exception being when
\code{enddate} is less than 24 hours after \code{startdate}. In that case, a
single day is returned.
}
\examples{
library(AirSensor)

example_pat \%>\%
  pat_filterDate(startdate = 20180808, enddate = 20180815) \%>\%
  pat_multiPlot()

}
\seealso{
\link{pat_filter}

\link{pat_filterDatetime}
}
