% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_filter.R
\name{pat_filter}
\alias{pat_filter}
\title{General purpose data filtering for PurpleAir Timeseries objects}
\usage{
pat_filter(pat, ...)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{...}{Logical predicates defined in terms of the variables in the 
\code{pat$data}.}
}
\value{
A subset of the incoming \code{pat}.
}
\description{
A generalized data filter for \emph{pat} objects to 
choose rows/cases where conditions are true.  Multiple conditions are 
combined with \code{&} or separated by a comma. Only rows where the condition 
evaluates to TRUE are kept.Rows where the condition evaluates to \code{NA}
are dropped.
}
\examples{

library(AirSensor)

unhealthy <- pat_filter(example_pat, pm25_A > 55.5, pm25_B > 55.5)
head(unhealthy$data)

}
\seealso{
\link{pat_filterDate}

\link{pat_filterDatetime}
}
