% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_blog}
\alias{oxford_blog}
\title{Custom blog colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 6.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_blog
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_blog} provides the six custom blog colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The 6 custom blog colours are
\code{"science_blog"} (defined as HEX #0f7361),
\code{"science_blog_button"} (defined as HEX #09332b),
\code{"arts_blog"} (defined as HEX #721627),
\code{"arts_blog_button"} (defined as HEX #330d14),
\code{"books_blog"} (defined as HEX #cf7a30) and
\code{"books_blog_button"} (defined as HEX #9c4700).
}
\examples{
oxford_blog
unikn::seecol(oxford_blog, main = "Uni Oxford custom blog colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
