% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McGill.R
\docType{data}
\name{mcgill_grey}
\alias{mcgill_grey}
\title{Grey colour of McGill University, Canada}
\format{
An object of class \code{character} of length 1.
}
\source{
Colour definitions are based on \href{https://www.mcgill.ca}{McGill}'s 
\href{https://www.mcgill.ca/visual-identity/visual-identity-guide}{visual identity guide}.
}
\usage{
mcgill_grey
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{mcgill_grey} provides the cool grey 
of \href{https://www.mcgill.ca}{McGill University}, Canada.
}
\details{
The colour is 
\code{"cool grey"} (defined as CMYK 66/52/44/17, RGB 93/103/113, HEX #5D6770).

\code{mcgill_grey} uses the HEX colour definition.


\href{https://www.mcgill.ca}{McGill}'s secondary colours are not official, 
but rather suggested colours that cover a larger spectrum to complement the primary \code{"McGill red"}. 
They can be used to add variety and contrast for headings, bullets, background and other graphic elements. 

Note that the CMYK colour differs from RGB and HEX definition.
}
\examples{
mcgill_grey
unikn::seecol(mcgill_grey, main = "Cool grey of McGill") # view colour palette

}
\seealso{
\code{\link{mcgill_red}} for the primary colour of McGill University; 
\code{\link{mcgill_pastels}} for the pastel colours of McGill;
\code{\link{mcgill_brights}} for the bright colours of McGill;
\code{\link{mcgill_muted}} for the muted colours of McGill;
\code{\link{mcgill_darks}} for the dark colours of McGill;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
