% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HU_Berlin.R
\docType{data}
\name{hu_1_2022}
\alias{hu_1_2022}
\title{Primary colors of the Humboldt University (HU) Berlin, Germany (2022)}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on 
\url{https://www.hu-berlin.de/de/service/design/basiselemente/farbe}.
}
\usage{
hu_1_2022
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{hu_1_2022} provides the three primary colors 
of the \href{https://www.hu-berlin.de/en}{Humboldt University Berlin}, Germany, 
up to 2022.
}
\details{
The color \code{"HU blau"} is defined as \code{Pantone 294} and approximated by \code{RGB 0/55/108}.
Other approximations include \code{CMYK 100/60/0/20}, \code{RGB 0/51/102} (reduced web scale), and \code{RAL 270 3040}.

See the \code{\link{ac}} and \code{\link{usecol}} functions 
of the \strong{unikn} package for creating color gradients.
}
\examples{
hu_1_2022
unikn::seecol(hu_1_2022, n = 5, main = "5 shades of HU Berlin")  # view color palette
unikn::demopal(hu_1_2022, type = 1, main = "Colors of Humboldt University Berlin")

}
\seealso{
\code{\link{hu_2_2022}} for secondary colors of the HU Berlin (2022);  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-11-30.
}
\concept{German university color palettes}
\keyword{datasets}
