% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cardiff.R
\docType{data}
\name{cardiff_1}
\alias{cardiff_1}
\title{Primary colours of Cardiff University, Wales}
\format{
An object of class \code{character} of length 12.
}
\source{
Colour definitions are based on \href{https://www.cardiff.ac.uk}{Cardiff University}'s 
User Experience Style Guide (PDF, v2 of 04/06/2013).
}
\usage{
cardiff_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{cardiff_1} provides the four primary colours (plus 8 tints)
of the \href{https://www.cardiff.ac.uk}{Cardiff University}, Wales, UK.
}
\details{
The 4 primary colours are 
\code{"Cardiff red"}, defined as HEX \code{"#d3374a"} or R:211 G: 55 B: 74, 
\code{"Cardiff grey"}, defined as HEX \code{"#d3d3d2"} or R:211 G:211 B:210,
\code{"Cardiff black}, defined as HEX \code{"#22211f"} or R: 34 G: 33 B: 31, and 
\code{"white"}, defined as HEX \code{"#ffffff"} or R:255 G:255 B:255. 

\code{cardiff_1} uses the HEX color definitions.


Colour is used on the University site for way-finding as well as 
to improve contrast and visibility of content.

The primary \href{https://www.cardiff.ac.uk}{Cardiff University} 
colour palette should be used consistently throughout its application 
of the User Experience Style Guidelines.

The primary \href{https://www.cardiff.ac.uk}{Cardiff University} colour palette 
contains a spectrum of 8 tints from light to dark grey. 
These can be used mainly as graphical backgrounds, button overstates etc.
}
\examples{
cardiff_1
unikn::seecol(cardiff_1, col_bg = "grey96",  
              main = "Primary colours of Cardiff University (w/8 tints)")

}
\seealso{
\code{\link{cardiff_2}} for examples of secondary colours of Cardiff University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Welsh university color palettes: 
\code{\link{aberystwyth_1}},
\code{\link{aberystwyth_2}},
\code{\link{bangor_1}},
\code{\link{bangor_2}},
\code{\link{bangor_3}},
\code{\link{bangor_4}},
\code{\link{cardiff_2}}
}
\author{
\strong{unicol}, 2023-09-10.
}
\concept{Welsh university color palettes}
\keyword{datasets}
