% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thesaurus.R
\name{as.thesaurus}
\alias{as.thesaurus}
\title{Create a list of trait definitions (a thesaurus of traits)}
\usage{
as.thesaurus(..., replace = NULL)
}
\arguments{
\item{...}{multiple objects of class 'trait' (produced by function
\code{as.trait()}) or a data.frame containing columns according to the terms
provided by https://ecologicaltraitdata.github.io/ETS/#terms-for-thesauri.}

\item{replace}{named character vector, with new names as values, and old names as names.}
}
\value{
a list of formalized objects of class 'trait', as returned by
function as.trait().
}
\description{
Create a trait thesaurus object for use as a reference object/lookup table of
traits within function \code{standardize.traits()}.
}
\details{
the object class 'trait' comprises necessary information to map a
trait name to a  trait definition, a target unit and a globally unique
identifier. The thesaurus will be used in function 'standardize.traits()'
to apply unit conversion and factor level harmonization.
}
\examples{

# provide traitlist by defining individual traits using function `as.trait()`:

traitlist <- as.thesaurus(body_length = as.trait("body_length", expectedUnit = "mm", 
    valueType = "numeric", 
    identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Body_length"), 
  antenna_length = as.trait("antenna_length", expectedUnit = "mm", 
    valueType = "numeric", 
    identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Antenna_length"),
  metafemur_length = as.trait("metafemur_length", expectedUnit = "mm", 
    valueType = "numeric", 
    identifier = "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Femur_length")
)

# provide traitlist from data frame object: 

as.thesaurus(data.frame(
  trait = c("body_length", "antenna_length", "metafemur_length", "eyewidth_corr"),
  expectedUnit = "mm",
  valueType = "numeric",
  traitDescription = c("body length in mm", "length of antenna in mm", 
                              "length of metafemur in mm", "eye width in mm"), 
  identifier = c("http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Body_length", 
    "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Antenna_length", 
    "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Femur_length", 
    "http://t-sita.cesab.org/BETSI_vizInfo.jsp?trait=Eye_diameter"
    )
)
)

# provide traitlist from remote archive with renaming  
# (pulls from https://github.com/EcologicalTraitData/TraitDataList)

\dontrun{
traits1 <- as.thesaurus(read.csv("https://git.io/fpsj5"), 
                   replace = c(traitID = "identifier", 
                                  traitName = "trait",
                                  traitUnit = "expectedUnit",
                                  Comments = "comments") 
)
}
}
